/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.filter;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFilter {
    private Logger logger = LoggerFactory.getLogger(BasicFilter.class);
    protected List<Pattern> urlFilters = new ArrayList<Pattern>();

    public BasicFilter() {
        this.urlFilters.add(Pattern.compile(".*?/doc\\.html.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/v2/api-docs.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/v2/api-docs-ext.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/swagger-resources.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/swagger-ui\\.html.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/swagger-resources/configuration/ui.*", 2));
        this.urlFilters.add(Pattern.compile(".*?/swagger-resources/configuration/security.*", 2));
    }

    protected boolean match(String uri) {
        boolean match = false;
        if (uri != null) {
            for (Pattern pattern : this.getUrlFilters()) {
                if (!pattern.matcher(uri).matches()) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    protected String decodeBase64(String source) {
        String decodeStr = null;
        if (source != null) {
            try {
                byte[] bytes = Base64.getDecoder().decode(source);
                decodeStr = new String(bytes);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        return decodeStr;
    }

    public List<Pattern> getUrlFilters() {
        return this.urlFilters;
    }
}

