/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.core.io;

import com.github.xiaoymin.knife4j.core.io.VFS;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtil.class);
    Set<Class<?>> classes = new HashSet();
    private ClassLoader classLoader;

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ResourceUtil find(String ... packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException("packageName can't be Empty!");
        }
        for (String packageName : packageNames) {
            String packagePath = this.getPackagePath(packageName);
            try {
                Set<String> children = this.collectPaths(packagePath);
                for (String file : children) {
                    if (!file.endsWith(".class")) continue;
                    String name = file.substring(0, file.indexOf(46)).replace('/', '.');
                    try {
                        this.classes.add(this.getClassLoader().loadClass(name));
                    }
                    catch (Throwable t) {
                        logger.warn("Could not examine class '" + file + "' due to a " + t.getClass().getName() + " with message: " + t.getMessage());
                    }
                }
            }
            catch (IOException e) {
                logger.error("Could not read package: " + packageName, e);
            }
        }
        return this;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    public Set<String> collectPaths(String packagePath) throws IOException {
        HashSet<String> list = new HashSet<String>();
        list.addAll(VFS.getInstance().list(packagePath));
        list.addAll(VFS.getInstance().list("/" + packagePath));
        return list;
    }
}

