package net.polyv.vclass.v1.entity.file;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vclass.v1.entity.VClassPageLimitCommonRequest;

/**
 * 查询课节已上传文档列表请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询课节已上传文档列表请求实体")
public class VClassDocListRequest extends VClassPageLimitCommonRequest {
    
    /**
     * 课节号
     */
    @ApiModelProperty(name = "lessonId", value = "课节号", required = true)
    @NotNull(message = "属性lessonId不能为空")
    private Long lessonId;
    
    /**
     * 文档状态，默认不传查询所有 normal：正常 waitUpload：等待上传 failUpload：上传失败 waitConvert：转换PPT中 failConvert：转换PPT失败
     */
    @ApiModelProperty(name = "status", value = "文档状态，默认不传查询所有 normal：正常 waitUpload：等待上传 failUpload：上传失败 " +
            "waitConvert：转换PPT中 failConvert：转换PPT失败", required = false)
    private String status;
    
    /**
     * 是否展示文档原文件地址，默认不传不展示 Y：是 N：否
     */
    @ApiModelProperty(name = "isShowUrl", value = "是否展示文档原文件地址，默认不传不展示 Y：是 N：否", required = false)
    private String isShowUrl;
    
}