package net.polyv.vclass.v1.config;

import lombok.extern.slf4j.Slf4j;
import net.polyv.common.v1.entity.AccountInfo;
import net.polyv.common.v1.util.FileUtil;

/**
 * @author: sadboy
 **/
@Slf4j
public class InitConfig {
    private InitConfig() {
    }
    
    /**
     * 初始化配置
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     */
    public static void initPolyvVClass(String appId, String userId, String appSecret) {
        VClassGlobalConfig.init(appId, userId, appSecret);
        log.debug("--初始化完成--");
    }
    
    
    /**
     * 初始化配置
     * 从文件读取JSON初始化配置，JSON格式如下：liveConfig:直播配置，vodConfig：点播配置
     * {"liveConfig":{"appId":"xxx","userId":"xxx","appSecret":"xxx"},"vodConfig":{"userId":"xxx","writeToken":"xxxxxxe","readToken":"xxxxxx","secretKey":"xxxx"}}
     * @param path 配置文件路径
     */
    public static void initPolyvVClassByFile(String path) {
        AccountInfo accountInfo = FileUtil.readConfigFromFile(path);
        String userId = accountInfo.getLiveConfig().getUserId();
        String appId = accountInfo.getLiveConfig().getAppId();
        String appSecret = accountInfo.getLiveConfig().getAppSecret();
        InitConfig.initPolyvVClass(appId, userId, appSecret);
    }
}
