package net.polyv.vclass.v1.config;

import net.polyv.common.v1.base.HttpClientUtil;

/**
 * @author: sadboy
 **/
public class VClassGlobalConfig {
    private VClassGlobalConfig() {
    }
    
    private static String APP_ID = "";
    private static String USER_ID = "";
    private static String APP_SECRET = "";
    public static final String SDK_NAME = "JAVA_VCLASS_SDK";
    
    public static String getAppId() {
        return APP_ID;
    }
    
    public static String getUserId() {
        return USER_ID;
    }
    
    public static String getAppSecret() {
        return APP_SECRET;
    }
    
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     */
    public static void init(String appId, String userId, String appSecret) {
        VClassGlobalConfig.APP_ID = appId;
        VClassGlobalConfig.USER_ID = userId;
        VClassGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.init();
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     * @param timeOut timeOut
     * @param maxClientNum maxClientNum
     */
    public static void init(String appId, String userId, String appSecret, Integer timeOut, Integer maxClientNum) {
        VClassGlobalConfig.APP_ID = appId;
        VClassGlobalConfig.USER_ID = userId;
        VClassGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.setTimeOut(timeOut);
        HttpClientUtil.setMaxClientNum(maxClientNum);
        HttpClientUtil.init();
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     * @param hostName 代理地址
     * @param port 代理端口
     * @param scheme 协议，默认为http
     */
    public static void init(String appId, String userId, String appSecret, String hostName, int port, String scheme) {
        VClassGlobalConfig.APP_ID = appId;
        VClassGlobalConfig.USER_ID = userId;
        VClassGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.init(hostName, port, scheme);
    }
    
    /**
     * 系统全局初始化
     * @param appId appId
     * @param userId userId
     * @param appSecret appSecret
     * @param timeOut 超时时间
     * @param maxClientNum 链接池最大并发连接数
     * @param hostName 代理地址
     * @param port 代理端口
     * @param scheme 协议，默认为http
     */
    public static void init(String appId, String userId, String appSecret, Integer timeOut, Integer maxClientNum,
            String hostName, int port, String scheme) {
        VClassGlobalConfig.APP_ID = appId;
        VClassGlobalConfig.USER_ID = userId;
        VClassGlobalConfig.APP_SECRET = appSecret;
        HttpClientUtil.setTimeOut(timeOut);
        HttpClientUtil.setMaxClientNum(maxClientNum);
        HttpClientUtil.init(hostName, port, scheme);
    }
}
