package net.polyv.vclass.v1.service.lesson;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.vclass.v1.entity.lesson.VClassAddLessonRequest;
import net.polyv.vclass.v1.entity.lesson.VClassAddLessonResponse;
import net.polyv.vclass.v1.entity.lesson.VClassCutoffLessonRequest;
import net.polyv.vclass.v1.entity.lesson.VClassDeleteLessonRequest;
import net.polyv.vclass.v1.entity.lesson.VClassGetLessonInfoRequest;
import net.polyv.vclass.v1.entity.lesson.VClassGetLessonInfoResponse;
import net.polyv.vclass.v1.entity.lesson.VClassGetLessonLiveInfoRequest;
import net.polyv.vclass.v1.entity.lesson.VClassGetLessonLiveInfoResponse;
import net.polyv.vclass.v1.entity.lesson.VClassGetPlaybackVideoRequest;
import net.polyv.vclass.v1.entity.lesson.VClassGetPlaybackVideoResponse;
import net.polyv.vclass.v1.entity.lesson.VClassResumeLessonRequest;
import net.polyv.vclass.v1.entity.lesson.VClassUpdateLessonInfoRequest;

/**
 * 互动学堂课节管理
 * @author: jiangyifan
 */
public interface VClassLessonService {
    
    /**
     * 创建课节
     * API地址：https://help.polyv.net/#/vclass/api/lesson/add_lesson
     * @param vClassAddLessonRequest 创建课节请求实体
     * @return 创建课节响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    VClassAddLessonResponse addLesson(VClassAddLessonRequest vClassAddLessonRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 获取课节信息
     * API地址：https://help.polyv.net/#/vclass/api/lesson/get_lesson
     * @param vClassGetLessonInfoRequest 获取课节信息请求实体
     * @return 获取课节信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    VClassGetLessonInfoResponse getLessonInfo(VClassGetLessonInfoRequest vClassGetLessonInfoRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 更新课节信息
     * API地址：https://help.polyv.net/#/vclass/api/lesson/update_lesson
     * @param vClassUpdateLessonInfoRequest 更新课节信息请求实体
     * @return 更新课节信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateLessonInfo(VClassUpdateLessonInfoRequest vClassUpdateLessonInfoRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除课节
     * API地址：https://help.polyv.net/#/vclass/api/lesson/delete_lesson
     * @param vClassDeleteLessonRequest 删除课节请求实体
     * @return 删除课节响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteLesson(VClassDeleteLessonRequest vClassDeleteLessonRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改课节状态为禁止上课
     * API地址：https://help.polyv.net/#/vclass/api/lesson/cutoff
     * @param vClassCutoffLessonRequest 修改课节状态为禁止上课请求实体
     * @return 修改课节状态为禁止上课响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean cutoffLesson(VClassCutoffLessonRequest vClassCutoffLessonRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 恢复课节状态为可以上课
     * API地址：https://help.polyv.net/#/vclass/api/lesson/resume
     * @param vClassResumeLessonRequest 恢复课节状态为可以上课请求实体
     * @return 恢复课节状态为可以上课响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean resumeLesson(VClassResumeLessonRequest vClassResumeLessonRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询课节实时状态和在线人数
     * API地址：https://help.polyv.net/#/vclass/api/lesson/get_lesson_live_info
     * @param vClassGetLessonLiveInfoRequest 查询课节实时状态和在线人数请求实体
     * @return 查询课节实时状态和在线人数响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<VClassGetLessonLiveInfoResponse> getLessonLiveInfo(
            VClassGetLessonLiveInfoRequest vClassGetLessonLiveInfoRequest) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询课节回放视频
     * API地址：https://help.polyv.net/#/vclass/api/lesson/get_playback_video
     * @param vClassGetPlaybackVideoRequest 查询课节回放视频请求实体
     * @return 查询课节回放视频响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<VClassGetPlaybackVideoResponse> getPlaybackVideo(VClassGetPlaybackVideoRequest vClassGetPlaybackVideoRequest)
            throws IOException, NoSuchAlgorithmException;
    
}
