package net.polyv.vclass.v1.service.file.impl;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

import net.polyv.vclass.v1.constant.VClassURL;
import net.polyv.vclass.v1.entity.file.VClassDeleteDocRequest;
import net.polyv.vclass.v1.entity.file.VClassDocListRequest;
import net.polyv.vclass.v1.entity.file.VClassDocListResponse;
import net.polyv.vclass.v1.entity.file.VClassUploadDocRequest;
import net.polyv.vclass.v1.entity.file.VClassUploadDocResponse;
import net.polyv.vclass.v1.service.VClassBaseService;
import net.polyv.vclass.v1.service.file.VClassFileService;

/**
 * 互动学堂文档管理
 * @author: jiangyifan
 */
public class VClassFileServiceImpl extends VClassBaseService implements VClassFileService {
    
    /**
     * 上传文档到某个课节
     * API地址：https://help.polyv.net/#/vclass/api/file/upload_doc
     * @param vClassUploadDocRequest 上传文档到某个课节请求实体
     * @return 上传文档到某个课节响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public VClassUploadDocResponse uploadDoc(VClassUploadDocRequest vClassUploadDocRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_UPLOAD_DOC_URL;
        Map<String, File> fileMap = new HashMap<String, File>();
        File file = vClassUploadDocRequest.getFile();
        if (file != null) {
            fileMap.put("file", file);
        }
        return this.uploadOneFile(url, vClassUploadDocRequest, fileMap, VClassUploadDocResponse.class);
    }
    
    /**
     * 查询课节已上传文档列表
     * API地址：https://help.polyv.net/#/vclass/api/file/doc_list
     * @param vClassDocListRequest 查询课节已上传文档列表请求实体
     * @return 查询课节已上传文档列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public VClassDocListResponse listDoc(VClassDocListRequest vClassDocListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_DOC_LIST_URL;
        return this.getReturnOne(url, vClassDocListRequest, VClassDocListResponse.class);
    }
    
    /**
     * 删除文档
     * API地址：https://help.polyv.net/#/vclass/api/file/delete_doc
     * @param vClassDeleteDocRequest 删除文档请求实体
     * @return 删除文档响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteDoc(VClassDeleteDocRequest vClassDeleteDocRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = VClassURL.VCLASS_DELETE_DOC_URL;
        this.postFormBodyReturnOne(url, vClassDeleteDocRequest, Boolean.class);
        return Boolean.TRUE;
    }
    
}
