package net.polyv.vclass.v1.entity.statistics;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.vclass.v1.entity.VClassPageCommonResponse;

/**
 * 基于课节维度查询用户信息响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("基于课节维度查询用户信息响应实体")
public class VClassLessonStatisticsResponse extends VClassPageCommonResponse {
    
    /**
     * 请求成功时的有关信息【详见Data参数描述】，请求失败时为空
     */
    @ApiModelProperty(name = "data", value = "请求成功时的有关信息【详见Data参数描述】，请求失败时为空", required = false)
    private List<LessonStatistics> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("请求成功时的有关信息【详见Data参数描述】，请求失败时为空")
    public static class LessonStatistics {
        
        /**
         * 用户ID
         */
        @ApiModelProperty(name = "viewerId", value = "用户ID", required = false)
        private String viewerId;
        
        /**
         * 用户昵称
         */
        @ApiModelProperty(name = "name", value = "用户昵称", required = false)
        private String name;
        
        /**
         * 进入时间，格式：年月日时分秒 yyyy-MM-dd HH:mm:ss
         */
        @ApiModelProperty(name = "startTime", value = "进入时间，格式：年月日时分秒 yyyy-MM-dd HH:mm:ss", required = false)
        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private Date startTime;
        
        /**
         * 离开房间，格式：年月日时分秒 yyyy-MM-dd HH:mm:ss
         */
        @ApiModelProperty(name = "endTime", value = "离开房间，格式：年月日时分秒 yyyy-MM-dd HH:mm:ss", required = false)
        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private Date endTime;
        
        /**
         * 连麦时长，格式：时分秒 HH:mm:ss
         */
        @ApiModelProperty(name = "joinDuration", value = "连麦时长，格式：时分秒 HH:mm:ss", required = false)
        private String joinDuration;
        
        /**
         * ip
         */
        @ApiModelProperty(name = "ip", value = "ip", required = false)
        private String ip;
        
        /**
         * 用户设备
         */
        @ApiModelProperty(name = "userAgent", value = "用户设备", required = false)
        private String userAgent;
        
        /**
         * 操作系统，是Windows 还是Mac；安卓，iOS；其他
         */
        @ApiModelProperty(name = "operatingSystem", value = "操作系统，是Windows 还是Mac；安卓，iOS；其他", required = false)
        private String operatingSystem;
        
        /**
         * 浏览器，例如Chrome 93
         */
        @ApiModelProperty(name = "browser", value = "浏览器，例如Chrome 93", required = false)
        private String browser;
        
        /**
         * 国家
         */
        @ApiModelProperty(name = "country", value = "国家", required = false)
        private String country;
        
        /**
         * 省份
         */
        @ApiModelProperty(name = "province", value = "省份", required = false)
        private String province;
        
        /**
         * 城市
         */
        @ApiModelProperty(name = "city", value = "城市", required = false)
        private String city;
        
        /**
         * 运营商
         */
        @ApiModelProperty(name = "isp", value = "运营商", required = false)
        private String isp;
        
    }
}