package net.polyv.vclass.v1.entity.lesson;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vclass.v1.entity.VClassCommonRequest;

/**
 * 更新课节信息请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("更新课节信息请求实体")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class VClassUpdateLessonInfoRequest extends VClassCommonRequest {
    /**
     * 课节号
     */
    @ApiModelProperty(name = "lessonId", value = "课节号", required = true)
    @NotNull(message = "属性lessonId不能为空")
    private Long lessonId;
    
    /**
     * 课节名称，长度1~128
     */
    @ApiModelProperty(name = "name", value = "课节名称，长度1~128", required = false)
    private String name;
    
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间", required = false)
    private Date startTime;
    
    /**
     * 上课时长，单位: 分钟，5~180
     */
    @ApiModelProperty(name = "duration", value = "上课时长，单位: 分钟，5~180", required = false)
    private Integer duration;
    
    /**
     * 连麦人数，0~16
     */
    @ApiModelProperty(name = "linkNumber", value = "连麦人数，0~16", required = false)
    private Integer linkNumber;
    
    /**
     * 是否自动连麦 Y：自动连麦 N：手动上麦
     */
    @ApiModelProperty(name = "autoConnectMicroEnabled", value = "是否自动连麦 Y：自动连麦 N：手动上麦", required = false)
    private String autoConnectMicroEnabled;
    
    /**
     * 是否自动录制课程 Y：自动录制 N：手动录制
     */
    @ApiModelProperty(name = "autoRecordCourseEnabled", value = "是否自动录制课程 Y：自动录制 N：手动录制", required = false)
    private String autoRecordCourseEnabled;
    
    /**
     * 观看条件 NULL：无条件 CODE：验证码 WHITE_LIST：白名单 DIRECT：独立授权
     */
    @ApiModelProperty(name = "watchCondition", value = "观看条件 NULL：无条件 CODE：验证码 WHITE_LIST：白名单 DIRECT：独立授权", required
            = false)
    private String watchCondition;
    
    /**
     * 当观看条件为CODE时需要填写观看验证码（限制16位以内）
     */
    @ApiModelProperty(name = "code", value = "当观看条件为CODE时需要填写观看验证码（限制16位以内）", required = false)
    private String code;
    
    /**
     * 观看条件为独立授权时传，不传则后台自动生成（限制32位以内）
     */
    @ApiModelProperty(name = "secretKey", value = "观看条件为独立授权时传，不传则后台自动生成（限制32位以内）", required = false)
    private String secretKey;
    
    /**
     * 录制清晰度, 720, 1080
     */
    @ApiModelProperty(name = "resolution", value = "录制清晰度, 720, 1080", required = false)
    private Integer resolution;
    
    /**
     * 上课清晰度, 360 ,720 ,1080（如果需要设置更高的清晰度，请联系相关工作人员）
     */
    @ApiModelProperty(name = "playResolution", value = "上课清晰度, 360（如果需要设置更高的清晰度，请联系相关工作人员）", required = false)
    private Integer playResolution;
    
    /**
     * 封面地址URL，长度1~255
     */
    @ApiModelProperty(name = "cover", value = "封面地址URL，长度1~255", required = false)
    private String cover;
    
    /**
     * 老师id，如不传，则不更新，如果传入的是新的id，则根据下列老师信息创新一个新的老师
     */
    @ApiModelProperty(name = "teacherId", value = "老师id，如不传，则不更新，如果传入的是新的id，则根据下列老师信息创新一个新的老师", required = false)
    private String teacherId;
    
    /**
     * 老师名称，如传入的信息可以查找到现有老师，会更新老师名称
     */
    @ApiModelProperty(name = "teacherName", value = "老师名称，如传入的信息可以查找到现有老师，会更新老师名称", required = false)
    private String teacherName;
    
    /**
     * 老师登录手机区号，默认 +86
     */
    @ApiModelProperty(name = "teacherCode", value = "老师登录手机区号，默认 +86", required = false)
    private String teacherCode;
    
    /**
     * 老师手机号，长度5~15
     */
    @ApiModelProperty(name = "teacherMobile", value = "老师手机号，长度5~15", required = false)
    private String teacherMobile;
    
    /**
     * 老师密码，长度6~8
     */
    @ApiModelProperty(name = "teacherPasswd", value = "老师密码，长度6~8", required = false)
    private String teacherPasswd;
    
}