package net.polyv.vclass.v1.entity.file;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.vclass.v1.entity.VClassPageLimitCommonRequest;

/**
 * 删除文档请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("删除文档请求实体")
public class VClassDeleteDocRequest extends VClassPageLimitCommonRequest {
    
    /**
     * 课节号
     */
    @ApiModelProperty(name = "lessonId", value = "课节号", required = true)
    @NotNull(message = "属性lessonId不能为空")
    private Long lessonId;
    
    /**
     * 文件ID，(如果有多个，可以用英文逗号隔开拼接成字符串)，该值来源参考【查询课节已上传文档列表】接口返回数据的data.contents[0].fileId
     */
    @ApiModelProperty(name = "fileId", value = "文件ID，(如果有多个，可以用英文逗号隔开拼接成字符串)，该值来源参考【查询课节已上传文档列表】接口返回数据的data" +
            ".contents[0].fileId", required = true)
    @NotNull(message = "属性fileId不能为空")
    private String fileId;
    
}