/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.vclass.v1.util;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.vclass.v1.config.VClassGlobalConfig;
import net.polyv.vclass.v1.entity.VClassCommonRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VClassSignUtil {
    private static final Logger log = LoggerFactory.getLogger(VClassSignUtil.class);

    private VClassSignUtil() {
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String setVClassSign(Map<String, String> params, String appSecret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String sign = VClassSignUtil.getSign(params, appSecret);
        params.put("sign", sign);
        return sign;
    }

    public static String getSign(Map<String, String> params, String appId, String appSecret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        params.put("appId", appId);
        return VClassSignUtil.getSign(params, appSecret);
    }

    public static String getSign(Map<String, String> params, String appSecret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        log.debug("\u53c2\u4e0e\u7b7e\u540d\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
        String concatStr = VClassSignUtil.concatParams(params);
        String plain = appSecret + concatStr + appSecret;
        log.debug("\u7b7e\u540d\u539f\u59cb\u5b57\u7b26\u4e32\uff1a{}", (Object)plain);
        String encrypted = VClassSignUtil.md5Hex(plain).toUpperCase();
        log.debug("\u7b7e\u540d\u7ed3\u679c\uff1a {}", (Object)encrypted);
        return encrypted;
    }

    public static String concatParams(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value = params.get(key);
            if (StringUtils.isBlank((String)value)) continue;
            sb.append(key).append(value);
        }
        return sb.toString();
    }

    public static String md5Hex(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] inputByteArray = text.getBytes("UTF-8");
        messageDigest.update(inputByteArray);
        byte[] resultByteArray = messageDigest.digest();
        return VClassSignUtil.byteArrayToHex(resultByteArray).toLowerCase();
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static <T extends VClassCommonRequest> Map<String, String> getSignMap(T t) {
        t.setAppId(VClassGlobalConfig.getAppId());
        if (StringUtils.isBlank((String)t.getTimestamp())) {
            t.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("appId", t.getAppId());
        tempMap.put("timestamp", t.getTimestamp());
        tempMap.put("requestId", t.getRequestId());
        return tempMap;
    }
}

