package net.polyv.vclass.v1.service.file;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.vclass.v1.entity.file.VClassDeleteDocRequest;
import net.polyv.vclass.v1.entity.file.VClassDocListRequest;
import net.polyv.vclass.v1.entity.file.VClassDocListResponse;
import net.polyv.vclass.v1.entity.file.VClassUploadDocRequest;
import net.polyv.vclass.v1.entity.file.VClassUploadDocResponse;

/**
 * 互动学堂文档管理
 * @author: jiangyifan
 */
public interface VClassFileService {
    
    /**
     * 上传文档到某个课节
     * API地址：https://help.polyv.net/#/vclass/api/file/upload_doc
     * @param vClassUploadDocRequest 上传文档到某个课节请求实体
     * @return 上传文档到某个课节响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    VClassUploadDocResponse uploadDoc(VClassUploadDocRequest vClassUploadDocRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询课节已上传文档列表
     * API地址：https://help.polyv.net/#/vclass/api/file/doc_list
     * @param vClassDocListRequest 查询课节已上传文档列表请求实体
     * @return 查询课节已上传文档列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    VClassDocListResponse listDoc(VClassDocListRequest vClassDocListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除文档
     * API地址：https://help.polyv.net/#/vclass/api/file/delete_doc
     * @param vClassDeleteDocRequest 删除文档请求实体
     * @return 删除文档响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteDoc(VClassDeleteDocRequest vClassDeleteDocRequest) throws IOException, NoSuchAlgorithmException;
    
}
