package net.polyv.vclass.v1.constant;

/**
 * 互动学堂请求地址
 * @author: sadboy
 **/
public class VClassURL {
    
    private static boolean isHttps = true;
    
    private static final String BASE_URI = "api.polyv.net/hi-class-api";
    
    /**
     * 设置自定义域名
     */
    private static String customUri = "";
    
    /**
     * url 替换通配符
     */
    private static final String PARAM_REPLACE_CHAR = "%s";
    
    /**
     * 获取替换参数后的URL地址
     * @param format 格式化
     * @param param 格式参数
     * @return 格式化后字符串
     */
    public static String getRealUrl(String format, Object... param) {
        return String.format(format, param);
    }
    
    public static boolean getIsHttps() {
        return isHttps;
    }
    
    /**
     * 设置互动学堂协议为http
     */
    public static void setVClassHttpProtocol() {
        isHttps = false;
    }
    
    /**
     * 设置互动学堂协议为https
     */
    public static void setVClassHttpsProtocol() {
        isHttps = true;
    }
    
    public static String getCustomUri() {
        return customUri;
    }
    
    /**
     * 设置自定义域名
     */
    public static void setCustomUri(String customUri) {
        VClassURL.customUri = customUri;
    }
    
    /**
     * 课节管理
     */
    
    /**
     * 创建课节
     */
    public static final String VCLASS_ADD_LESSON_URL = BASE_URI + "/open/lesson/v1/add";
    
    /**
     * 获取课节信息
     */
    public static final String VCLASS_GET_LESSON_URL = BASE_URI + "/open/lesson/v1/get";
    
    /**
     * 更新课节信息
     */
    public static final String VCLASS_UPDATE_LESSON_URL = BASE_URI + "/open/lesson/v1/update";
    
    /**
     * 删除课节
     */
    public static final String VCLASS_DELETE_LESSON_URL = BASE_URI + "/open/lesson/v1/delete";
    
    /**
     * 修改课节状态为禁止上课
     */
    public static final String VCLASS_CUTOFF_LESSON_URL =
            BASE_URI + "/open/lesson/v1/" + PARAM_REPLACE_CHAR + "/cutoff";
    
    /**
     * 恢复课节状态为可以上课
     */
    public static final String VCLASS_RESUME_LESSON_URL =
            BASE_URI + "/open/lesson/v1/" + PARAM_REPLACE_CHAR + "/resume";
    
    /**
     * 查询课节实时状态和在线人数
     */
    public static final String VCLASS_GET_LESSON_LIVE_INFO_URL = BASE_URI + "/open/lesson/v1/getLessonLiveInfo";
    
    /**
     * 查询课节回放视频
     */
    public static final String VCLASS_GET_LESSON_PLAYBACK_VIDEO_URL = BASE_URI + "/open/lesson/v1/getPlaybackVideo";
    
    /**
     * 文档管理
     */
    
    /**
     * 上传文档到某个课节
     */
    public static final String VCLASS_UPLOAD_DOC_URL = BASE_URI + "/open/file/v1/upload-doc";
    
    /**
     * 查询课节已上传文档列表
     */
    public static final String VCLASS_DOC_LIST_URL = BASE_URI + "/open/file/v1/doc-list";
    
    /**
     * 删除文档
     */
    public static final String VCLASS_DELETE_DOC_URL = BASE_URI + "/open/file/v1/delete";
    
    /**
     * 统计功能
     */
    
    /**
     * 基于课节维度查询用户信息
     */
    public static final String VCLASS_STATISTICS_LESSON_URL = BASE_URI + "/open/statistics/v1/list";
    
}
