package net.polyv.vclass.v1.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 互动学堂常量
 * @author: jiangyifan
 */
public class VClassConstant {
    
    public static final String UTF8 = "UTF-8";
    
    /**
     * 通用条件判断
     */
    @Getter
    @AllArgsConstructor
    public enum Flag {
        YES("Y"), NO("N");
        
        private String flag;
    }
    
    /**
     * 互动学堂观看条件
     */
    @Getter
    @AllArgsConstructor
    public enum AuthType {
        /**
         * 观看条件：无条件
         */
        NULL("NULL"),
        /**
         * 观看条件：白名单
         */
        WHITE_LIST("WHITE_LIST"),
        /**
         * 观看条件：验证码观看
         */
        CODE("CODE"),
        /**
         * 观看条件：直接授权
         */
        DIRECT("DIRECT");
        
        private final String code;
    }
}
