/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.seminar.v1.service.auth.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.util.MapUtil;
import net.polyv.seminar.v1.entity.auth.SeminarGetAuthSettingRequest;
import net.polyv.seminar.v1.entity.auth.SeminarGetAuthSettingResponse;
import net.polyv.seminar.v1.entity.auth.SeminarSetAuthSettingRequest;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.auth.SeminarAuthService;
import net.polyv.seminar.v1.util.SeminarSignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeminarAuthServiceImpl
extends SeminarBaseService
implements SeminarAuthService {
    private static final Logger log = LoggerFactory.getLogger(SeminarAuthServiceImpl.class);

    @Override
    public List<SeminarGetAuthSettingResponse> getAuthSetting(SeminarGetAuthSettingRequest seminarGetAuthSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/seminar/setting/auth/get";
        return this.getReturnList(url, seminarGetAuthSettingRequest, SeminarGetAuthSettingResponse.class);
    }

    @Override
    public Boolean setAuthSetting(SeminarSetAuthSettingRequest seminarSetAuthSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/seminar/setting/auth/set";
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarSetAuthSettingRequest);
        signMap.put("channelId", seminarSetAuthSettingRequest.getChannelId());
        url = MapUtil.appendUrl((String)url, signMap);
        this.postJsonBodyReturnOne(url, signMap, seminarSetAuthSettingRequest, String.class);
        return Boolean.TRUE;
    }
}

