package net.polyv.seminar.v1.service.whitelist.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.whitelist.SeminarDeleteAllWhitelistRequest;
import net.polyv.seminar.v1.entity.whitelist.SeminarDeleteWhitelistRequest;
import net.polyv.seminar.v1.entity.whitelist.SeminarGetWhitelistRequest;
import net.polyv.seminar.v1.entity.whitelist.SeminarGetWhitelistResponse;
import net.polyv.seminar.v1.entity.whitelist.SeminarUpdateWhitelistRequest;
import net.polyv.seminar.v1.entity.whitelist.SeminarWhitelistSaveBatchRequest;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.whitelist.SeminarWhitelistService;
import net.polyv.seminar.v1.util.SeminarSignUtil;

/**
 * 白名单管理
 * @author: liyongxuan
 */
public class SeminarWhitelistServiceImpl extends SeminarBaseService implements SeminarWhitelistService {
    
    
    /**
     * 批量新增白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_save_batch
     * @param seminarWhitelistSaveBatchRequest 批量新增白名单请求实体
     * @return 批量新增白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean whitelistSaveBatch(SeminarWhitelistSaveBatchRequest seminarWhitelistSaveBatchRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_WHITELIST_SAVE_BATCH_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarWhitelistSaveBatchRequest);
        signMap.put("channelId", seminarWhitelistSaveBatchRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarWhitelistSaveBatchRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 删除单个白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_delete
     * @param seminarDeleteWhitelistRequest 删除单个白名单请求实体
     * @return 删除单个白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteWhitelist(SeminarDeleteWhitelistRequest seminarDeleteWhitelistRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_DELETE_WHITELIST_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarDeleteWhitelistRequest);
        signMap.put("channelId", seminarDeleteWhitelistRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarDeleteWhitelistRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 清空白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_delete_all
     * @param seminarDeleteAllWhitelistRequest 清空白名单请求实体
     * @return 清空白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteAllWhitelist(SeminarDeleteAllWhitelistRequest seminarDeleteAllWhitelistRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_DELETE_ALL_WHITELIST_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarDeleteAllWhitelistRequest);
        signMap.put("channelId", seminarDeleteAllWhitelistRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarDeleteAllWhitelistRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 分页查询白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_get
     * @param seminarGetWhitelistRequest 分页查询白名单请求实体
     * @return 分页查询白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public SeminarGetWhitelistResponse getWhitelist(SeminarGetWhitelistRequest seminarGetWhitelistRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_GET_WHITELIST_URL;
        return this.getReturnOne(url, seminarGetWhitelistRequest, SeminarGetWhitelistResponse.class);
    }
    
    /**
     * 更新白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_update
     * @param seminarUpdateWhitelistRequest 更新白名单请求实体
     * @return 更新白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateWhitelist(SeminarUpdateWhitelistRequest seminarUpdateWhitelistRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_UPDATE_WHITELIST_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarUpdateWhitelistRequest);
        signMap.put("channelId", seminarUpdateWhitelistRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarUpdateWhitelistRequest, String.class);
        return Boolean.TRUE;
    }
}
