package net.polyv.seminar.v1.service.monitor;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.seminar.v1.entity.monitor.SeminarMonitorListAccountRequest;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorListAccountResponse;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorQuerySettingRequest;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorQuerySettingResponse;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorUpdateAccountRequest;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorUpdateSettingRequest;

/**
 * 监播管理
 * @author: liyongxuan
 */
public interface IMonitorService {
    
    /**
     * 查询轮询监控账号
     * API地址：https://help.polyv.net/#/seminar/api/monitor/monitor_list_account
     * @param seminarMonitorListAccountRequest 查询轮询监控账号请求实体
     * @return 查询轮询监控账号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<SeminarMonitorListAccountResponse> monitorListAccount(
            SeminarMonitorListAccountRequest seminarMonitorListAccountRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询轮询监控开关
     * API地址：https://help.polyv.net/#/seminar/api/monitor/monitor_query_setting
     * @param seminarMonitorQuerySettingRequest 查询轮询监控开关请求实体
     * @return 查询轮询监控开关响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    SeminarMonitorQuerySettingResponse monitorQuerySetting(
            SeminarMonitorQuerySettingRequest seminarMonitorQuerySettingRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改轮询监控账号信息
     * API地址：https://help.polyv.net/#/seminar/api/monitor/monitor_update_account
     * @param seminarMonitorUpdateAccountRequest 修改轮询监控账号信息请求实体
     * @return 修改轮询监控账号信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean monitorUpdateAccount(SeminarMonitorUpdateAccountRequest seminarMonitorUpdateAccountRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改轮询监控开关
     * API地址：https://help.polyv.net/#/seminar/api/monitor/monitor_update_setting
     * @param seminarMonitorUpdateSettingRequest 修改轮询监控开关请求实体
     * @return 修改轮询监控开关响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean monitorUpdateSetting(SeminarMonitorUpdateSettingRequest seminarMonitorUpdateSettingRequest)
            throws IOException, NoSuchAlgorithmException;
    
}
