package net.polyv.seminar.v1.service.group;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.seminar.v1.entity.group.SeminarDeleteAllGroupPlanRequest;
import net.polyv.seminar.v1.entity.group.SeminarDeleteGroupPlanRequest;
import net.polyv.seminar.v1.entity.group.SeminarGetGroupPlanRequest;
import net.polyv.seminar.v1.entity.group.SeminarGetGroupPlanResponse;
import net.polyv.seminar.v1.entity.group.SeminarSaveBatchGroupPlanRequest;
import net.polyv.seminar.v1.entity.group.SeminarUpdateGroupPlanRequest;

/**
 * 分组管理
 * @author: liyongxuan
 */
public interface IGroupPlanService {
    
    /**
     * 删除单个分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_delete
     * @param seminarDeleteGroupPlanRequest 删除单个分组记录请求实体
     * @return 删除单个分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteGroupPlan(SeminarDeleteGroupPlanRequest seminarDeleteGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 清空分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_delete_all
     * @param seminarDeleteAllGroupPlanRequest 清空分组记录请求实体
     * @return 清空分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteAllGroupPlan(SeminarDeleteAllGroupPlanRequest seminarDeleteAllGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_get
     * @param seminarGetGroupPlanRequest 查询分组记录请求实体
     * @return 查询分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    SeminarGetGroupPlanResponse getGroupPlan(SeminarGetGroupPlanRequest seminarGetGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 批量新增分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_save_batch
     * @param seminarSaveBatchGroupPlanRequest 批量新增分组记录请求实体
     * @return 批量新增分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean saveBatchGroupPlan(SeminarSaveBatchGroupPlanRequest seminarSaveBatchGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 更新单个分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_update
     * @param seminarUpdateGroupPlanRequest 更新单个分组记录请求实体
     * @return 更新单个分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateGroupPlan(SeminarUpdateGroupPlanRequest seminarUpdateGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException;
    
}
