package net.polyv.seminar.v1.entity.whitelist;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 更新白名单请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("更新白名单请求实体")
public class SeminarUpdateWhitelistRequest extends SeminarCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 需要更新的原白名单记录，长度不超过64位
     */
    @ApiModelProperty(name = "oldCode", value = "需要更新的原白名单记录，长度不超过64位", required = true)
    @NotNull(message = "属性oldCode不能为空")
    private String oldCode;
    
    /**
     * 新的白名单记录，长度不超过64位
     */
    @ApiModelProperty(name = "code", value = "新的白名单记录，长度不超过64位", required = true)
    @NotNull(message = "属性code不能为空")
    private String code;
    
    /**
     * 新的昵称，长度不超过64位（不传则不修改）
     */
    @ApiModelProperty(name = "name", value = "新的昵称，长度不超过64位（不传则不修改）", required = false)
    private String name;
    
    /**
     * 新的分组序号，1~50之间（不传则不修改）
     */
    @ApiModelProperty(name = "groupNo", value = "新的分组序号，1~50之间（不传则不修改）", required = false)
    private Integer groupNo;
    
    /**
     * 新的组内身份（不传则不修改） leader：组长 member：组员
     */
    @ApiModelProperty(name = "groupRole", value = "新的组内身份（不传则不修改） leader：组长 member：组员", required = false)
    private String groupRole;
    
}