package net.polyv.seminar.v1.entity.monitor;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询轮询监控账号响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询轮询监控账号响应实体")
public class SeminarMonitorListAccountResponse {
    
    /**
     * 监播员登录账号，不可修改
     */
    @ApiModelProperty(name = "id", value = "监播员登录账号，不可修改", required = false)
    private Integer id;
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 监播员昵称，支持1-16位长度
     */
    @ApiModelProperty(name = "nickname", value = "监播员昵称，支持1-16位长度", required = false)
    private String nickname;
    
    /**
     * 密码，支持6-16位长度
     */
    @ApiModelProperty(name = "password", value = "密码，支持6-16位长度", required = false)
    private String password;
    
}