package net.polyv.seminar.v1.service.whitelist;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.seminar.v1.entity.whitelist.SeminarDeleteAllWhitelistRequest;
import net.polyv.seminar.v1.entity.whitelist.SeminarDeleteWhitelistRequest;
import net.polyv.seminar.v1.entity.whitelist.SeminarGetWhitelistRequest;
import net.polyv.seminar.v1.entity.whitelist.SeminarGetWhitelistResponse;
import net.polyv.seminar.v1.entity.whitelist.SeminarUpdateWhitelistRequest;
import net.polyv.seminar.v1.entity.whitelist.SeminarWhitelistSaveBatchRequest;

/**
 * 白名单管理
 * @author: liyongxuan
 */
public interface SeminarWhitelistService {
    
    /**
     * 批量新增白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_save_batch
     * @param seminarWhitelistSaveBatchRequest 批量新增白名单请求实体
     * @return 批量新增白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean whitelistSaveBatch(SeminarWhitelistSaveBatchRequest seminarWhitelistSaveBatchRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除单个白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_delete
     * @param seminarDeleteWhitelistRequest 删除单个白名单请求实体
     * @return 删除单个白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteWhitelist(SeminarDeleteWhitelistRequest seminarDeleteWhitelistRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 清空白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_delete_all
     * @param seminarDeleteAllWhitelistRequest 清空白名单请求实体
     * @return 清空白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteAllWhitelist(SeminarDeleteAllWhitelistRequest seminarDeleteAllWhitelistRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 分页查询白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_get
     * @param seminarGetWhitelistRequest 分页查询白名单请求实体
     * @return 分页查询白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    SeminarGetWhitelistResponse getWhitelist(SeminarGetWhitelistRequest seminarGetWhitelistRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 更新白名单
     * API地址：https://help.polyv.net/#/seminar/api/whitelist/whitelist_update
     * @param seminarUpdateWhitelistRequest 更新白名单请求实体
     * @return 更新白名单响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateWhitelist(SeminarUpdateWhitelistRequest seminarUpdateWhitelistRequest)
            throws IOException, NoSuchAlgorithmException;
}
