package net.polyv.seminar.v1.service.auth;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.seminar.v1.entity.auth.SeminarGetAuthSettingRequest;
import net.polyv.seminar.v1.entity.auth.SeminarGetAuthSettingResponse;
import net.polyv.seminar.v1.entity.auth.SeminarSetAuthSettingRequest;

/**
 * 参会管理
 * @author: jiangyifan
 */
public interface SeminarAuthService {
    
    /**
     * 查询研讨会参会条件
     * API地址：https://help.polyv.net/index.html#/seminar/api/auth/get_seminar_auth
     * @param seminarGetAuthSettingRequest 查询研讨会参会条件请求实体
     * @return 查询研讨会参会条件响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<SeminarGetAuthSettingResponse> getAuthSetting(SeminarGetAuthSettingRequest seminarGetAuthSettingRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改研讨会参会条件
     * API地址：https://help.polyv.net/#/seminar/api/auth/set_seminar_auth
     * @param seminarSetAuthSettingRequest 修改研讨会参会条件请求实体
     * @return 修改研讨会参会条件响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean setAuthSetting(SeminarSetAuthSettingRequest seminarSetAuthSettingRequest)
            throws IOException, NoSuchAlgorithmException;
}
