package net.polyv.seminar.v1.entity.monitor;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 修改轮询监控账号信息请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改轮询监控账号信息请求实体")
public class SeminarMonitorUpdateAccountRequest extends SeminarCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 监控轮询账号
     */
    @ApiModelProperty(name = "id", value = "监控轮询账号", required = true)
    @NotNull(message = "属性id不能为空")
    private Integer id;
    
    /**
     * 监播员昵称，支持1-16位长度（不传则不修改）
     */
    @ApiModelProperty(name = "nickname", value = "监播员昵称，支持1-16位长度（不传则不修改）", required = false)
    private String nickname;
    
    /**
     * 密码，支持6-16位长度（不传则不修改）
     */
    @ApiModelProperty(name = "password", value = "密码，支持6-16位长度（不传则不修改）", required = false)
    private String password;
    
}