package net.polyv.seminar.v1.entity.group;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 批量新增分组记录请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量新增分组记录请求实体")
public class SeminarSaveBatchGroupPlanRequest extends SeminarCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 批量插入记录
     */
    @ApiModelProperty(name = "list", value = "批量插入记录", required = true)
    @NotNull(message = "属性list不能为空")
    private List<GroupPlan> list;
    
    @Data
    public static class GroupPlan {
        
        /**
         * 参会人id，长度不超过64位（不可重复）
         */
        @ApiModelProperty(name = "viewerId", value = "参会人id，长度不超过64位（不可重复）", required = true)
        @NotNull(message = "属性viewerId不能为空")
        private String viewerId;
        
        /**
         * 参会人昵称，长度不超过64位（仅作为辨认依据，不改变用户参会名称）
         */
        @ApiModelProperty(name = "nickname", value = "参会人昵称，长度不超过64位（仅作为辨认依据，不改变用户参会名称）", required = true)
        @NotNull(message = "属性nickname不能为空")
        private String nickname;
        
        /**
         * 分组序号，1~50之间
         */
        @ApiModelProperty(name = "groupNo", value = "分组序号，1~50之间", required = true)
        @NotNull(message = "属性groupNo不能为空")
        private Integer groupNo;
        
        /**
         * 组内身份，一个分组内不能多于一个组长 leader：组长 member：组员
         */
        @ApiModelProperty(name = "groupRole", value = "组内身份，一个分组内不能多于一个组长 leader：组长 member：组员", required = true)
        @NotNull(message = "属性groupRole不能为空")
        private String groupRole;
    }
    
}