package net.polyv.seminar.v1.entity.group;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.seminar.v1.entity.SeminarPageCommonResponse;

/**
 * 查询分组记录响应实体
 * @author liyongxuan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询分组记录响应实体")
public class SeminarGetGroupPlanResponse extends SeminarPageCommonResponse {
    
    /**
     * 查询的结果列表
     */
    @ApiModelProperty(name = "contents", value = "查询的结果列表", required = false)
    private List<SeminarGetGroupPlanResponse.GroupPlan> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表")
    public static class GroupPlan {
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 账号id
         */
        @ApiModelProperty(name = "userId", value = "账号id", required = false)
        private String userId;
        
        /**
         * 参会人id
         */
        @ApiModelProperty(name = "viewerId", value = "参会人id", required = false)
        private String viewerId;
        
        /**
         * 参会人昵称（仅作为辨认依据，不改变用户参会名称）
         */
        @ApiModelProperty(name = "nickname", value = "参会人昵称（仅作为辨认依据，不改变用户参会名称）", required = false)
        private String nickname;
        
        /**
         * 分组序号
         */
        @ApiModelProperty(name = "groupNo", value = "分组序号", required = false)
        private Integer groupNo;
        
        /**
         * 分组名称
         */
        @ApiModelProperty(name = "groupName", value = "分组名称", required = false)
        private String groupName;
        
        /**
         * 组内身份 leader：组长 member：组员
         */
        @ApiModelProperty(name = "groupRole", value = "组内身份 leader：组长 member：组员", required = false)
        private String groupRole;
        
    }
    
}