package net.polyv.seminar.v1.entity.auth;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询研讨会参会条件响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询研讨会参会条件响应实体")
public class SeminarGetAuthSettingResponse {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 用户ID
     */
    @ApiModelProperty(name = "userId", value = "用户ID", required = false)
    private String userId;
    
    /**
     * 用于实现一个频道设置两个参会条件，为1或2（1为主要条件，2为次要条件）
     */
    @ApiModelProperty(name = "rank", value = "用于实现一个频道设置两个参会条件，为1或2（1为主要条件，2为次要条件）", required = false)
    private Integer rank;
    
    /**
     * 是否开启参会条件 N：关闭 Y：开启
     */
    @ApiModelProperty(name = "enabled", value = "是否开启参会条件 N：关闭 Y：开启", required = false)
    private String enabled;
    
    /**
     * 参会条件类型 password：密码登录 direct：独立授权
     */
    @ApiModelProperty(name = "authType", value = "参会条件类型 password：密码登录 direct：独立授权", required = false)
    private String authType;
    
    /**
     * 角色 host：主持人 attendee：参会人
     */
    @ApiModelProperty(name = "roleCode", value = "角色 host：主持人 attendee：参会人", required = false)
    private String roleCode;
    
    /**
     * 密码登录的password
     */
    @ApiModelProperty(name = "password", value = "密码登录的password", required = false)
    private String password;
    
    /**
     * 独立授权key
     */
    @ApiModelProperty(name = "directKey", value = "独立授权key", required = false)
    private String directKey;
    
    /**
     * 角色名称
     */
    @ApiModelProperty(name = "roleName", value = "角色名称", required = false)
    private String roleName;
    
    /**
     * 自定义授权观看的key
     */
    @ApiModelProperty(name = "customKey", value = "自定义授权观看的key", required = false)
    private String customKey;
    
    /**
     * 自定义授权观看的接口地址
     */
    @ApiModelProperty(name = "customUri", value = "自定义授权观看的接口地址", required = false)
    private String customUri;
    
}