/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.seminar.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import net.polyv.seminar.v1.config.SeminarGlobalConfig;
import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.channel.SeminarBatchDeleteChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelResponse;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelV2Request;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelV2Response;
import net.polyv.seminar.v1.entity.channel.SeminarDeleteChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetCdnViewLogRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetCdnViewLogResponse;
import net.polyv.seminar.v1.entity.channel.SeminarGetLiveTypeRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetLiveTypeResponse;
import net.polyv.seminar.v1.entity.channel.SeminarGetRecordSettingRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetRecordSettingResponse;
import net.polyv.seminar.v1.entity.channel.SeminarGetViewLogRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetViewLogResponse;
import net.polyv.seminar.v1.entity.channel.SeminarSetRecordSettingRequest;
import net.polyv.seminar.v1.entity.channel.SeminarUpdateLiveTypeRequest;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.channel.SeminarChannelService;
import net.polyv.seminar.v1.util.SeminarSignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeminarChannelServiceImpl
extends SeminarBaseService
implements SeminarChannelService {
    private static final Logger log = LoggerFactory.getLogger(SeminarChannelServiceImpl.class);

    @Override
    public SeminarCreateChannelResponse createChannel(SeminarCreateChannelRequest seminarCreateChannelRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/basic/create";
        return this.postJsonBodyReturnOne(url, seminarCreateChannelRequest, SeminarCreateChannelResponse.class);
    }

    @Override
    public SeminarCreateChannelV2Response createChannelV2(SeminarCreateChannelV2Request seminarCreateChannelV2Request) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/create";
        return this.postJsonBodyReturnOne(url, seminarCreateChannelV2Request, SeminarCreateChannelV2Response.class);
    }

    @Override
    public SeminarGetRecordSettingResponse getRecordSetting(SeminarGetRecordSettingRequest seminarGetRecordSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/seminar/setting/get-record";
        return this.getReturnOne(url, seminarGetRecordSettingRequest, SeminarGetRecordSettingResponse.class);
    }

    @Override
    public Boolean setRecordSetting(SeminarSetRecordSettingRequest seminarSetRecordSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/seminar/setting/set-record";
        this.postFormBodyReturnOne(url, seminarSetRecordSettingRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public SeminarGetViewLogResponse getViewLog(SeminarGetViewLogRequest seminarGetViewLogRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/seminar/statistics/listViewLogs";
        return this.getReturnOne(url, seminarGetViewLogRequest, SeminarGetViewLogResponse.class);
    }

    @Override
    public SeminarGetCdnViewLogResponse getCdnViewLog(SeminarGetCdnViewLogRequest seminarGetCdnViewLogRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/statistics/listViewLogs";
        return this.getReturnOne(url, seminarGetCdnViewLogRequest, SeminarGetCdnViewLogResponse.class);
    }

    @Override
    public Boolean deleteChannel(SeminarDeleteChannelRequest seminarDeleteChannelRequest) throws IOException, NoSuchAlgorithmException {
        seminarDeleteChannelRequest.setUserId(SeminarGlobalConfig.getUserId());
        String url = SeminarURL.getRealUrl("api.polyv.net/live/v2/channels/%s/delete", seminarDeleteChannelRequest.getChannelId());
        return this.postFormBodyReturnOne(url, seminarDeleteChannelRequest, Boolean.class);
    }

    @Override
    public Boolean batchDeleteChannel(SeminarBatchDeleteChannelRequest seminarBatchDeleteChannelRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/basic/batch-delete";
        return this.postJsonBodyReturnOne(url, seminarBatchDeleteChannelRequest, Boolean.class);
    }

    @Override
    public SeminarGetLiveTypeResponse getLiveType(SeminarGetLiveTypeRequest seminarGetLiveTypeRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/meet/v1/channel/live-type/get";
        return this.getReturnOne(url, seminarGetLiveTypeRequest, SeminarGetLiveTypeResponse.class);
    }

    @Override
    public Boolean updateLiveType(SeminarUpdateLiveTypeRequest seminarUpdateLiveTypeRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/meet/v1/channel/live-type/update";
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarUpdateLiveTypeRequest);
        signMap.put("channelId", seminarUpdateLiveTypeRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarUpdateLiveTypeRequest, String.class);
        return Boolean.TRUE;
    }
}

