package net.polyv.seminar.v1.service.auth.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import net.polyv.common.v1.util.MapUtil;
import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.auth.SeminarGetAuthSettingRequest;
import net.polyv.seminar.v1.entity.auth.SeminarGetAuthSettingResponse;
import net.polyv.seminar.v1.entity.auth.SeminarSetAuthSettingRequest;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.auth.SeminarAuthService;
import net.polyv.seminar.v1.util.SeminarSignUtil;

/**
 * 参会管理
 * @author: jiangyifan
 */
@Slf4j
public class SeminarAuthServiceImpl extends SeminarBaseService implements SeminarAuthService {
    
    /**
     * 查询研讨会参会条件
     * API地址：https://help.polyv.net/index.html#/seminar/api/auth/get_seminar_auth
     * @param seminarGetAuthSettingRequest 查询研讨会参会条件请求实体
     * @return 查询研讨会参会条件响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<SeminarGetAuthSettingResponse> getAuthSetting(SeminarGetAuthSettingRequest seminarGetAuthSettingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_GET_SEMINAR_AUTH_URL;
        return this.getReturnList(url, seminarGetAuthSettingRequest, SeminarGetAuthSettingResponse.class);
    }
    
    /**
     * 修改研讨会参会条件
     * API地址：https://help.polyv.net/#/seminar/api/auth/set_seminar_auth
     * @param seminarSetAuthSettingRequest 修改研讨会参会条件请求实体
     * @return 修改研讨会参会条件响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean setAuthSetting(SeminarSetAuthSettingRequest seminarSetAuthSettingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_SET_SEMINAR_AUTH_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarSetAuthSettingRequest);
        signMap.put("channelId", seminarSetAuthSettingRequest.getChannelId());
        url = MapUtil.appendUrl(url, signMap);
        this.postJsonBodyReturnOne(url, signMap, seminarSetAuthSettingRequest, String.class);
        return Boolean.TRUE;
    }
}
