package net.polyv.seminar.v1.entity.whitelist;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 批量新增白名单请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量新增白名单请求实体")
public class SeminarWhitelistSaveBatchRequest extends SeminarCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 批量插入记录
     */
    @ApiModelProperty(name = "list", value = "批量插入记录", required = true)
    @NotNull(message = "属性list不能为空")
    private List<SeminarWhitelistSaveBatchRequest.WhitelistInfo> list;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("白名单信息")
    public static class WhitelistInfo {
        /**
         * 会员码，长度不超过64位（不可重复）
         */
        @ApiModelProperty(name = "code", value = "会员码，长度不超过64位（不可重复）", required = true)
        @NotNull(message = "属性code不能为空")
        private String code;
        
        /**
         * 参会人昵称，长度不超过64位
         */
        @ApiModelProperty(name = "name", value = "参会人昵称，长度不超过64位", required = true)
        @NotNull(message = "属性name不能为空")
        private String name;
        
        /**
         * 分组序号，1~50之间（需与组内身份同时传或同时不传）
         */
        @ApiModelProperty(name = "groupNo", value = "分组序号，1~50之间（需与组内身份同时传或同时不传）", required = false)
        private Integer groupNo;
        
        /**
         * 组内身份，一个分组内不能多于一个组长（需与分组序号同时传或同时不传） leader：组长 member：组员
         */
        @ApiModelProperty(name = "groupRole", value = "组内身份，一个分组内不能多于一个组长（需与分组序号同时传或同时不传） leader：组长 member：组员",
                required = false)
        private String groupRole;
    }
    
}