package net.polyv.seminar.v1.entity.group;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 更新单个分组记录请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("更新单个分组记录请求实体")
public class SeminarUpdateGroupPlanRequest extends SeminarCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 需要更新的分组记录的原参会人id，长度不超过64位
     */
    @ApiModelProperty(name = "oldViewerId", value = "需要更新的分组记录的原参会人id，长度不超过64位", required = true)
    @NotNull(message = "属性oldViewerId不能为空")
    private String oldViewerId;
    
    /**
     * 新的参会人id，长度不超过64位
     */
    @ApiModelProperty(name = "viewerId", value = "新的参会人id，长度不超过64位", required = false)
    private String viewerId;
    
    /**
     * 新的参会人昵称，长度不超过64位（仅作为辨认依据，不改变用户参会名称）
     */
    @ApiModelProperty(name = "nickname", value = "新的参会人昵称，长度不超过64位（仅作为辨认依据，不改变用户参会名称）", required = false)
    private String nickname;
    
    /**
     * 新的分组序号，1~50之间
     */
    @ApiModelProperty(name = "groupNo", value = "新的分组序号，1~50之间", required = false)
    private Integer groupNo;
    
    /**
     * 新的组内身份 leader：组长 member：组员
     */
    @ApiModelProperty(name = "groupRole", value = "新的组内身份 leader：组长 member：组员", required = false)
    private String groupRole;
    
}