package net.polyv.seminar.v1.entity.channel;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 修改研讨会频道录制设置请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改研讨会频道录制设置请求实体")
public class SeminarSetRecordSettingRequest extends SeminarCommonRequest {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 录制开关，Y开启、N关闭
     */
    @ApiModelProperty(name = "enabled", value = "录制开关，Y开启、N关闭", required = true)
    @NotNull(message = "属性enabled不能为空")
    private String enabled;
    
    /**
     * 录制模式，auto自动、manual手动
     */
    @ApiModelProperty(name = "recordMode", value = "录制模式，auto自动、manual手动", required = true)
    @NotNull(message = "属性recordMode不能为空")
    private String recordMode;
    
}