package net.polyv.seminar.v1.entity.channel;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarPageCommonRequest;

/**
 * 获取研讨会直播间参会者统计数据请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("获取研讨会直播间参会者统计数据请求实体")
public class SeminarGetViewLogRequest extends SeminarPageCommonRequest {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间", required = true)
    @NotNull(message = "属性startTime不能为空")
    private Date startTime;
    
    /**
     * 结束时间（最多只能查询60天内的数据）
     */
    @ApiModelProperty(name = "endTime", value = "结束时间（最多只能查询60天内的数据）", required = true)
    @NotNull(message = "属性endTime不能为空")
    private Date endTime;
    
}