package net.polyv.seminar.v1.entity.channel;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 获取研讨会频道录制设置响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("获取研讨会频道录制设置响应实体")
public class SeminarGetRecordSettingResponse {
    
    /**
     * 录制开关，Y开启、N关闭
     */
    @ApiModelProperty(name = "enabled", value = "录制开关，Y开启、N关闭", required = false)
    private String enabled;
    
    /**
     * 录制模式，auto自动、manual手动
     */
    @ApiModelProperty(name = "mode", value = "录制模式，auto自动、manual手动", required = false)
    private String mode;
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "直播频道号", required = false)
    private String channelId;
    
    /**
     * POLYV用户ID，通过注册保利威官网获取，路径：官网->登录->直播（开发设置）
     */
    @ApiModelProperty(name = "userId", value = "POLYV用户ID，通过注册保利威官网获取，路径：官网->登录->直播（开发设置）", required = false)
    private String userId;
    
    /**
     * 分辨率
     */
    @ApiModelProperty(name = "resolution", value = "分辨率", required = false)
    private String resolution;
    
}