package net.polyv.seminar.v1.constant;

/**
 * 研讨会相关URL
 * @author: jiangyifan
 */
public class SeminarURL {
    
    private static boolean isHttps = true;
    
    /**
     * POLYV live api base uri
     */
    private static final String BASE_URI = "api.polyv.net/live/";
    
    /**
     * POLYV live api base uri
     */
    private static final String MEET_V1_URL = "api.polyv.net/meet/";
    
    /**
     * 设置自定义域名
     */
    private static String customUri = "";
    
    /**
     * url 替换通配符
     */
    private static final String PARAM_REPLACE_CHAR = "%s";
    
    /**
     * 400错误码
     */
    public static final int CODE_400 = 400;
    
    /**
     * 200响应码
     */
    public static final int CODE_200 = 200;
    
    /**
     * 请求错误提示
     */
    public static final String REQUEST_ERR_MSG = "Bad Request";
    
    /**
     * 设置代理错误提示
     */
    public static final String PROXY_ERR_MSG = "Proxy Error";
    
    /**
     * 获取替换参数后的URL地址
     * @param format 格式化
     * @param param 格式参数
     * @return 格式化后字符串
     */
    public static String getRealUrl(String format, Object... param) {
        return String.format(format, param);
    }
    
    public static boolean getIsHttps() {
        return isHttps;
    }
    
    /**
     * 设置直播API协议为http
     */
    public static void setSeminarHttpProtocol() {
        isHttps = false;
    }
    
    /**
     * 设置直播API协议为https
     */
    public static void setSeminarHttpsProtocol() {
        isHttps = true;
    }
    
    public static String getCustomUri() {
        return customUri;
    }
    
    /**
     * 设置自定义域名
     */
    public static void setCustomUri(String customUri) {
        SeminarURL.customUri = customUri;
    }
    
    /**
     * 创建研讨会频道(旧版后台)
     */
    public static final String SEMINAR_CREATE_CHANNEL_URL = BASE_URI + "v3/channel/basic/create";
    
    /**
     * 创建研讨会频道(新版后台)
     */
    public static final String SEMINAR_CREATE_CHANNEL_V2_URL = BASE_URI + "v4/channel/create";
    
    /**
     * 获取研讨会频道录制设置
     */
    public static final String SEMINAR_GET_RECORD_URL = BASE_URI + "v3/channel/seminar/setting/get-record";
    
    /**
     * 修改研讨会频道录制设置
     */
    public static final String SEMINAR_SET_RECORD_URL = BASE_URI + "v3/channel/seminar/setting/set-record";
    
    /**
     * 获取研讨会直播间参会者统计数据
     */
    public static final String SEMINAR_GET_VIEW_LOG_URL = BASE_URI + "v3/channel/seminar/statistics/listViewLogs";
    
    /**
     * 获取直播间观众统计数据
     */
    public static final String SEMINAR_GET_CDN_VIEW_LOG_URL = BASE_URI + "v3/channel/statistics/listViewLogs";
    
    /**
     * 删除单个频道
     */
    public static final String SEMINAR_DELETE_CHANNEL_URL = BASE_URI + "v2/channels/" + PARAM_REPLACE_CHAR + "/delete";
    
    /**
     * 批量删除频道
     */
    public static final String SEMINAR_DELETE_CHANNEL_BATCH_URL = BASE_URI + "v3/channel/basic/batch-delete";
    
    /**
     * 查询录制视频
     */
    public static final String SEMINAR_GET_RECORD_FILES_URL =
            BASE_URI + "v2/channels/" + PARAM_REPLACE_CHAR + "/recordFiles";
    
    /**
     * 删除录制视频
     */
    public static final String SEMINAR_DELETE_RECORD_FILES_URL =
            BASE_URI + "v2/channel/recordFile/" + PARAM_REPLACE_CHAR + "/delete-record";
    
    /**
     * 查询研讨会参会条件
     */
    public static final String SEMINAR_GET_SEMINAR_AUTH_URL = BASE_URI + "v3/channel/seminar/setting/auth/get";
    
    /**
     * 修改研讨会参会条件
     */
    public static final String SEMINAR_SET_SEMINAR_AUTH_URL = BASE_URI + "v3/channel/seminar/setting/auth/set";
    
    /**
     * 删除研讨会分组记录
     */
    public static final String SEMINAR_DELETE_GROUP_PLAN_URL = BASE_URI + "v4/seminar/group/plan/delete";
    
    /**
     * 清空研讨会分组记录
     */
    public static final String SEMINAR_DELETE_ALL_GROUP_PLAN_URL = BASE_URI + "v4/seminar/group/plan/delete-all";
    
    /**
     * 查询分组记录
     */
    public static final String SEMINAR_GET_GROUP_PLAN_URL = BASE_URI + "v4/seminar/group/plan/get";
    
    /**
     * 批量新增分组记录
     */
    public static final String SEMINAR_SAVE_BATCH_GROUP_PLAN_URL = BASE_URI + "v4/seminar/group/plan/save-batch";
    
    /**
     * 更新单个分组记录
     */
    public static final String SEMINAR_UPDATE_GROUP_PLAN_URL = BASE_URI + "v4/seminar/group/plan/update";
    
    /**
     * 查询研讨会会议类型
     */
    public static final String SEMINAR_GET_TYPE_URL = MEET_V1_URL + "v1/channel/live-type/get";
    
    /**
     * 修改研讨会会议类型
     */
    public static final String SEMINAR_UPDATE_TYPE_URL = MEET_V1_URL + "v1/channel/live-type/update";
    
    /**
     * 查询轮询监控账号
     */
    public static final String SEMINAR_MONITOR_LIST_ACCOUNT_URL = BASE_URI + "v4/seminar/monitor/list";
    
    /**
     * 查询轮询监控开关
     */
    public static final String SEMINAR_MONITOR_QUERY_SETTING_URL = BASE_URI + "v4/seminar/monitor/querySetting";
    
    /**
     * 修改轮询监控账号信息
     */
    public static final String SEMINAR_MONITOR_UPDATE_ACCOUNT_URL = BASE_URI + "v4/seminar/monitor/update";
    
    /**
     * 修改轮询监控开关
     */
    public static final String SEMINAR_MONITOR_UPDATE_SETTING_URL = BASE_URI + "v4/seminar/monitor/updateSetting";
    
    /**
     * 批量新增白名单
     */
    public static final String SEMINAR_WHITELIST_SAVE_BATCH_URL = MEET_V1_URL + "v1/channel/auth-whitelist/save-batch";
    
    /**
     * 删除单个白名单
     */
    public static final String SEMINAR_DELETE_WHITELIST_URL = MEET_V1_URL + "v1/channel/auth-whitelist/delete";
    
    /**
     * 清空白名单
     */
    public static final String SEMINAR_DELETE_ALL_WHITELIST_URL = MEET_V1_URL + "v1/channel/auth-whitelist/delete-all";
    
    /**
     * 分页查询白名单
     */
    public static final String SEMINAR_GET_WHITELIST_URL = MEET_V1_URL + "v1/channel/auth-whitelist/get";
    
    /**
     * 更新白名单
     */
    public static final String SEMINAR_UPDATE_WHITELIST_URL = MEET_V1_URL + "v1/channel/auth-whitelist/update";
    
}
