/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.seminar.v1.service;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.base.HttpUtil;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.MapUtil;
import net.polyv.common.v1.util.SDKValidateUtil;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.seminar.v1.config.SeminarGlobalConfig;
import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;
import net.polyv.seminar.v1.entity.SeminarCommonResponse;
import net.polyv.seminar.v1.util.SeminarSignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeminarBaseService {
    private static final Logger log = LoggerFactory.getLogger(SeminarBaseService.class);
    public static final String ERROR_PREFIX = "\u4fdd\u5229\u5a01HTTP\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";
    public static final String ERROR_INFO = " ,\u9519\u8bef\u539f\u56e0\uff1a ";
    public static final String ERROR_SUFFIX = " ,\u9519\u8bef\u539f\u56e0\uff1a \u670d\u52a1\u5668\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e";
    public static final String ERROR_PREFIX1 = "\u4fdd\u5229\u5a01\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6c42\u6d41\u6c34\u53f7\uff1a";

    protected <T, E extends SeminarCommonRequest> T getReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseData(tClass);
    }

    protected <T, E extends SeminarCommonRequest> List<T> getReturnList(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.baseGet(url, e).parseArray(tClass);
    }

    private <E extends SeminarCommonRequest> SeminarCommonResponse baseGet(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        url = this.appendProtocol(url);
        String response = HttpUtil.get((String)url, paramMap, this.getHttpHeadMap());
        return this.responseConversion(response, e.getRequestId());
    }

    protected <E extends SeminarCommonRequest> byte[] getReturnBinary(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        byte[] response = HttpUtil.getBinary((String)(url = this.appendProtocol(url)), paramMap, this.getHttpHeadMap(), null);
        if (response == null) {
            String message = ERROR_PREFIX + e.getRequestId() + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(Constant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return response;
    }

    protected <T, E extends SeminarCommonRequest> T postFormBodyReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostFormBody(url, e).parseData(tClass);
    }

    protected <T, E extends SeminarCommonRequest> List<T> postFormBodyReturnList(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostFormBody(url, e).parseArray(tClass);
    }

    private <E extends SeminarCommonRequest> SeminarCommonResponse basePostFormBody(String url, E e) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        if ((url = this.appendProtocol(url)).contains("/live/v4/")) {
            url = MapUtil.appendUrl((String)url, paramMap);
        }
        String response = HttpUtil.postFormBody((String)url, paramMap, this.getHttpHeadMap());
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends SeminarCommonRequest> List<T> postJsonBodyReturnList(String url, Map<String, String> signMap, E e, String json, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJsonBody(url, signMap, e, json).parseArray(tClass);
    }

    protected <T, E extends SeminarCommonRequest> T postJsonBodyReturnOne(String url, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        Map<String, String> signMap = SeminarSignUtil.getSignMap(e);
        return this.basePostJsonBody(url, signMap, e, "").parseData(tClass);
    }

    protected <T, E extends SeminarCommonRequest> T postJsonBodyReturnOne(String url, Map<String, String> signMap, E e, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.basePostJsonBody(url, signMap, e, "").parseData(tClass);
    }

    private <E extends SeminarCommonRequest> SeminarCommonResponse basePostJsonBody(String url, Map<String, String> signMap, E e, String json) throws IOException, NoSuchAlgorithmException {
        signMap = this.commonRequestLogic(signMap, e);
        url = MapUtil.appendUrl((String)url, signMap);
        if (StringUtils.isBlank((String)json)) {
            json = JSON.toJSONString(e);
        }
        url = this.appendProtocol(url);
        String response = HttpUtil.postJsonBody((String)url, this.getHttpHeadMap(), (String)json, null);
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends SeminarCommonRequest> T uploadOneFile(String url, E e, Map<String, File> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.uploadOneFile(url, e, fileMap).parseData(tClass);
    }

    private <E extends SeminarCommonRequest> SeminarCommonResponse uploadOneFile(String url, E e, Map<String, File> fileMap) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("requestId", e.getRequestId());
        url = MapUtil.appendUrl((String)url, reqMap);
        url = this.appendProtocol(url);
        String response = HttpUtil.postFile((String)url, paramMap, fileMap, this.getHttpHeadMap(), null);
        return this.responseConversion(response, e.getRequestId());
    }

    protected <T, E extends SeminarCommonRequest> List<T> uploadMultipartFile(String url, E e, Map<String, List<File>> fileMap, Class<T> tClass) throws IOException, NoSuchAlgorithmException {
        return this.uploadMultipartFile(url, e, fileMap).parseArray(tClass);
    }

    private <E extends SeminarCommonRequest> SeminarCommonResponse uploadMultipartFile(String url, E e, Map<String, List<File>> fileMap) throws IOException, NoSuchAlgorithmException {
        Map<String, String> paramMap = this.commonRequestLogic(null, e);
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("requestId", e.getRequestId());
        url = MapUtil.appendUrl((String)url, reqMap);
        url = this.appendProtocol(url);
        String response = HttpUtil.postMultipleFile((String)url, paramMap, fileMap, this.getHttpHeadMap(), null);
        return this.responseConversion(response, e.getRequestId());
    }

    private <E extends SeminarCommonRequest> Map<String, String> commonRequestLogic(Map<String, String> signMap, E e) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String requestId;
        e.setAppId(SeminarGlobalConfig.getAppId());
        if (StringUtils.isBlank((String)e.getTimestamp())) {
            e.setTimestamp(String.valueOf(System.currentTimeMillis()));
        }
        if (StringUtils.isBlank((String)e.getRequestId())) {
            requestId = SeminarSignUtil.generateUUID();
            e.setRequestId(requestId);
        } else if (!e.getRequestId().matches("^[a-zA-Z0-9-_]{8,50}$")) {
            requestId = SeminarSignUtil.generateUUID();
            log.info("requestId\u5fc5\u987b\u7531\u5b57\u6bcd\u6570\u5b57\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u957f\u5ea6\u4e3a8-50\u4f4d\uff0c\u73b0\u91cd\u65b0\u8bbe\u7f6e\u4e3a\uff1a{}", (Object)requestId);
            e.setRequestId(requestId);
        }
        if (signMap == null) {
            signMap = MapUtil.objectToMap(e);
        } else {
            signMap.put("requestId", e.getRequestId());
        }
        signMap = MapUtil.filterNullValue((Map)signMap);
        String sign = SeminarSignUtil.setLiveSign(signMap, SeminarGlobalConfig.getAppSecret());
        e.setSign(sign);
        this.validateBean(e);
        return signMap;
    }

    private <E extends SeminarCommonRequest> void validateBean(E e) {
        List violationMsgList = SDKValidateUtil.validateBean(e, (Class[])new Class[0]);
        if (!violationMsgList.isEmpty()) {
            String errors = SDKValidateUtil.getViolationMsgStr((List)violationMsgList);
            errors = errors.substring(0, errors.length() - 3);
            errors = "\u8f93\u5165\u53c2\u6570 [" + ((Object)e).getClass().getName() + "]\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25 ,\u5931\u8d25\u5b57\u6bb5 [" + errors + "]";
            log.error(errors);
            throw new PloyvSdkException(Constant.ERROR_CODE, errors);
        }
    }

    private SeminarCommonResponse responseConversion(String response, String requestId) throws IOException, NoSuchAlgorithmException {
        SeminarCommonResponse seminarCommonResponse;
        if (StringUtils.isNotBlank((String)response)) {
            seminarCommonResponse = (SeminarCommonResponse)JSON.parseObject((String)response, SeminarCommonResponse.class);
            if (seminarCommonResponse.getCode() != 200) {
                SeminarCommonResponse.Error error;
                if (StringUtils.isNotBlank((String)seminarCommonResponse.getRequestId())) {
                    requestId = seminarCommonResponse.getRequestId();
                }
                String errorMessage = seminarCommonResponse.getMessage();
                int errorCode = seminarCommonResponse.getCode();
                if (StringUtils.isBlank((String)errorMessage) && (error = seminarCommonResponse.getError()) != null) {
                    if (StringUtils.isNotBlank((String)error.getDesc())) {
                        errorMessage = error.getDesc();
                    }
                    if (error.getCode() != 0) {
                        errorCode = error.getCode();
                    }
                }
                String message = ERROR_PREFIX1 + requestId + ERROR_INFO + errorMessage;
                PloyvSdkException exception = new PloyvSdkException(Integer.valueOf(errorCode), message);
                log.error(message, (Throwable)exception);
                throw exception;
            }
        } else {
            String message = ERROR_PREFIX + requestId + ERROR_SUFFIX;
            PloyvSdkException exception = new PloyvSdkException(Constant.ERROR_CODE, message);
            log.error(message, (Throwable)exception);
            throw exception;
        }
        return seminarCommonResponse;
    }

    private Map<String, String> getHttpHeadMap() {
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("source", "JAVA_SEMINAR_SDK");
        headMap.put("User-Agent", "JAVA_SEMINAR_SDK,2.1.17");
        headMap.put("version", "2.1.17");
        headMap.put("java-sdk-app-id", SeminarGlobalConfig.getAppId());
        headMap.put("java-sdk-user-id", SeminarGlobalConfig.getUserId());
        return headMap;
    }

    private String appendProtocol(String url) {
        url = this.removeProtocol(url);
        if (StringUtils.isNotEmpty((String)SeminarURL.getCustomUri()) && url.startsWith("api.polyv.net")) {
            url = url.replace("api.polyv.net", SeminarURL.getCustomUri());
        }
        url = SeminarURL.getIsHttps() ? "https://" + url : "http://" + url;
        return url;
    }

    private String removeProtocol(String url) {
        if ((url = url.trim()).startsWith("https://")) {
            url = url.substring(8);
        } else if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        return url;
    }
}

