package net.polyv.seminar.v1.service.monitor.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;

import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorListAccountRequest;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorListAccountResponse;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorQuerySettingRequest;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorQuerySettingResponse;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorUpdateAccountRequest;
import net.polyv.seminar.v1.entity.monitor.SeminarMonitorUpdateSettingRequest;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.monitor.IMonitorService;
import net.polyv.seminar.v1.util.SeminarSignUtil;

/**
 * 监播管理
 * @author: liyongxuan
 */
public class MonitorServiceImpl extends SeminarBaseService implements IMonitorService {
    
    /**
     * 查询轮询监控账号
     * API地址：https://help.polyv.net/#/seminar/api/monitor/monitor_list_account
     * @param seminarMonitorListAccountRequest 查询轮询监控账号请求实体
     * @return 查询轮询监控账号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<SeminarMonitorListAccountResponse> monitorListAccount(
            SeminarMonitorListAccountRequest seminarMonitorListAccountRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_MONITOR_LIST_ACCOUNT_URL;
        return this.getReturnList(url, seminarMonitorListAccountRequest, SeminarMonitorListAccountResponse.class);
    }
    
    /**
     * 查询轮询监控开关
     * API地址：https://help.polyv.net/#/seminar/api/monitor/monitor_query_setting
     * @param seminarMonitorQuerySettingRequest 查询轮询监控开关请求实体
     * @return 查询轮询监控开关响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public SeminarMonitorQuerySettingResponse monitorQuerySetting(
            SeminarMonitorQuerySettingRequest seminarMonitorQuerySettingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_MONITOR_QUERY_SETTING_URL;
        return this.getReturnOne(url, seminarMonitorQuerySettingRequest, SeminarMonitorQuerySettingResponse.class);
    }
    
    /**
     * 修改轮询监控账号信息
     * API地址：https://help.polyv.net/#/seminar/api/monitor/monitor_update_account
     * @param seminarMonitorUpdateAccountRequest 修改轮询监控账号信息请求实体
     * @return 修改轮询监控账号信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean monitorUpdateAccount(SeminarMonitorUpdateAccountRequest seminarMonitorUpdateAccountRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_MONITOR_UPDATE_ACCOUNT_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarMonitorUpdateAccountRequest);
        signMap.put("channelId", seminarMonitorUpdateAccountRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarMonitorUpdateAccountRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 修改轮询监控开关
     * API地址：https://help.polyv.net/#/seminar/api/monitor/monitor_update_setting
     * @param seminarMonitorUpdateSettingRequest 修改轮询监控开关请求实体
     * @return 修改轮询监控开关响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean monitorUpdateSetting(SeminarMonitorUpdateSettingRequest seminarMonitorUpdateSettingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_MONITOR_UPDATE_SETTING_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarMonitorUpdateSettingRequest);
        signMap.put("channelId", seminarMonitorUpdateSettingRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarMonitorUpdateSettingRequest, String.class);
        return Boolean.TRUE;
    }
}
