package net.polyv.seminar.v1.service.group.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.group.SeminarDeleteAllGroupPlanRequest;
import net.polyv.seminar.v1.entity.group.SeminarDeleteGroupPlanRequest;
import net.polyv.seminar.v1.entity.group.SeminarGetGroupPlanRequest;
import net.polyv.seminar.v1.entity.group.SeminarGetGroupPlanResponse;
import net.polyv.seminar.v1.entity.group.SeminarSaveBatchGroupPlanRequest;
import net.polyv.seminar.v1.entity.group.SeminarUpdateGroupPlanRequest;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.group.IGroupPlanService;
import net.polyv.seminar.v1.util.SeminarSignUtil;

/**
 * 分组管理
 * @author: liyongxuan
 */
public class GroupPlanServiceImpl extends SeminarBaseService implements IGroupPlanService {
    
    /**
     * 删除单个分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_delete
     * @param seminarDeleteGroupPlanRequest 删除单个分组记录请求实体
     * @return 删除单个分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteGroupPlan(SeminarDeleteGroupPlanRequest seminarDeleteGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_DELETE_GROUP_PLAN_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarDeleteGroupPlanRequest);
        signMap.put("channelId", seminarDeleteGroupPlanRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarDeleteGroupPlanRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 清空分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_delete_all
     * @param seminarDeleteAllGroupPlanRequest 清空分组记录请求实体
     * @return 清空分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteAllGroupPlan(SeminarDeleteAllGroupPlanRequest seminarDeleteAllGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_DELETE_ALL_GROUP_PLAN_URL;
        this.postFormBodyReturnOne(url, seminarDeleteAllGroupPlanRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_get
     * @param seminarGetGroupPlanRequest 查询分组记录请求实体
     * @return 查询分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public SeminarGetGroupPlanResponse getGroupPlan(SeminarGetGroupPlanRequest seminarGetGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_GET_GROUP_PLAN_URL;
        return this.getReturnOne(url, seminarGetGroupPlanRequest, SeminarGetGroupPlanResponse.class);
    }
    
    /**
     * 批量新增分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_save_batch
     * @param seminarSaveBatchGroupPlanRequest 批量新增分组记录请求实体
     * @return 批量新增分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean saveBatchGroupPlan(SeminarSaveBatchGroupPlanRequest seminarSaveBatchGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_SAVE_BATCH_GROUP_PLAN_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarSaveBatchGroupPlanRequest);
        signMap.put("channelId", seminarSaveBatchGroupPlanRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarSaveBatchGroupPlanRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 更新单个分组记录
     * API地址：https://help.polyv.net/#/seminar/api/group/group_plan_update
     * @param seminarUpdateGroupPlanRequest 更新单个分组记录请求实体
     * @return 更新单个分组记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateGroupPlan(SeminarUpdateGroupPlanRequest seminarUpdateGroupPlanRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_UPDATE_GROUP_PLAN_URL;
        Map<String, String> signMap = SeminarSignUtil.getSignMap(seminarUpdateGroupPlanRequest);
        signMap.put("channelId", seminarUpdateGroupPlanRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, seminarUpdateGroupPlanRequest, String.class);
        return Boolean.TRUE;
    }
}
