package net.polyv.seminar.v1.entity.playback;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询录制视频响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询录制视频响应实体")
public class SeminarGetRecordInfoResponse {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 录制文件ID
     */
    @ApiModelProperty(name = "fileId", value = "录制文件ID", required = false)
    private String fileId;
    
    /**
     * 录制文件地址，优先返回MP4，若没有MP4会返回M3U8
     */
    @ApiModelProperty(name = "url", value = "录制文件地址，优先返回MP4，若没有MP4会返回M3U8", required = false)
    private String url;
    
    /**
     * 开始录制时间，格式为：yyyyMMddHHmmss
     */
    @ApiModelProperty(name = "startTime", value = "开始录制时间，格式为：yyyyMMddHHmmss", required = false)
    private String startTime;
    
    /**
     * 结束录制时间，格式为：yyyyMMddHHmmss
     */
    @ApiModelProperty(name = "endTime", value = "结束录制时间，格式为：yyyyMMddHHmmss", required = false)
    private String endTime;
    
    /**
     * 录制文件大小（单位：字节）
     */
    @ApiModelProperty(name = "fileSize", value = "录制文件大小（单位：字节）", required = false)
    private Long fileSize;
    
    /**
     * 时长（单位：秒）
     */
    @ApiModelProperty(name = "duration", value = "时长（单位：秒）", required = false)
    private Integer duration;
    
    /**
     * 录制文件码率（单位：字节）
     */
    @ApiModelProperty(name = "bitrate", value = "录制文件码率（单位：字节）", required = false)
    private Integer bitrate;
    
    /**
     * 分辨率，示例：1280x720
     */
    @ApiModelProperty(name = "resolution", value = "分辨率，示例：1280x720", required = false)
    private String resolution;
    
    /**
     * 直播的场次ID
     */
    @ApiModelProperty(name = "channelSessionId", value = "直播的场次ID", required = false)
    private String channelSessionId;
    
    /**
     * 录制文件名称
     */
    @ApiModelProperty(name = "fileName", value = "录制文件名称", required = false)
    private String fileName;
    
    /**
     * 录制文件剩余天数，大于0：剩余天数，-1：永久，不会返回过期的录制文件记录
     */
    @ApiModelProperty(name = "daysLeft", value = "录制文件剩余天数，大于0：剩余天数，-1：永久，不会返回过期的录制文件记录", required = false)
    private Integer daysLeft;
    
    /**
     * 录制文件来源 manual：手动录制 auto：自动录制
     */
    @ApiModelProperty(name = "origin", value = "录制文件来源 manual：手动录制 auto：自动录制", required = false)
    private String origin;
    
    /**
     * 原始直播场次ID 当该录制文件为手动录制或自动录制时就等于当前直播场次ID
     */
    @ApiModelProperty(name = "originSessionId", value = "原始直播场次ID 当该录制文件为手动录制或自动录制时就等于当前直播场次ID", required = false)
    private String originSessionId;
    
    /**
     * 录制文件类型
     * complete：完整回放
     * part：自动录制_片段
     * merge：手动合并
     * clip：裁剪
     */
    @ApiModelProperty(name = "recordFileType", value = "录制文件类型 complete：完整回放,part：自动录制_片段,merge：手动合并,clip：裁剪",
            required = false)
    private String recordFileType;
    
}