package net.polyv.seminar.v1.entity.monitor;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 修改轮询监控开关请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改轮询监控开关请求实体")
public class SeminarMonitorUpdateSettingRequest extends SeminarCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 轮询监控开关， Y开启 N关闭
     */
    @ApiModelProperty(name = "enabled", value = "轮询监控开关， Y开启 N关闭", required = true)
    @NotNull(message = "属性enabled不能为空")
    private String enabled;
    
}