package net.polyv.seminar.v1.entity.channel;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 创建研讨会频道(新版后台)请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("创建研讨会频道(新版后台)请求实体")
public class SeminarCreateChannelV2Request extends SeminarCommonRequest {
    
    /**
     * 直播名称，最大长度100
     */
    @ApiModelProperty(name = "name", value = "直播名称，最大长度100", required = true)
    @NotNull(message = "属性name不能为空")
    private String name;
    
    /**
     * 直播场景 (seminar-研讨会)
     */
    @ApiModelProperty(hidden = true, required = true)
    @NotNull(message = "属性newScene不能为空")
    private String newScene = "seminar";
    
    /**
     * 研讨会主持人密码，仅直播场景是研讨会时有效，长度6-16位，不传则由系统随机生成。研讨会主持人密码和参会人密码不能相同。
     */
    @ApiModelProperty(name = "seminarHostPassword", value = "研讨会主持人密码，仅直播场景是研讨会时有效，长度6-16" +
            "位，不传则由系统随机生成。研讨会主持人密码和参会人密码不能相同。", required = false)
    private String seminarHostPassword;
    
    /**
     * 研讨会参会人密码，仅直播场景是研讨会时有效，长度6-16位，不传则由系统随机生成。研讨会主持人密码和参会人密码不能相同。
     */
    @ApiModelProperty(name = "seminarAttendeePassword", value = "研讨会参会人密码，仅直播场景是研讨会时有效，长度6-16" +
            "位，不传则由系统随机生成。研讨会主持人密码和参会人密码不能相同。", required = false)
    private String seminarAttendeePassword;
    
    /**
     * 引导页图片地址，非保利威域名下的图片需先调用[上传图片资源](/live/java/webSetting?id=_2、上传图片资源)上传
     */
    @ApiModelProperty(name = "splashImg", value = "引导页图片地址，非保利威域名下的图片需先调用[上传图片资源](/live/java/webSetting?id=_2、上传图片资源)上传", required = false)
    private String splashImg;
    
    /**
     * 分类ID，可通过“查询直播分类”接口获取
     */
    @ApiModelProperty(name = "categoryId", value = "分类ID，可通过“查询直播分类”接口获取", required = false)
    private Integer categoryId;
    
    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startTime", value = "开始时间", required = false)
    private Date startTime;
    
    /**
     * 子账号邮箱，填写时频道会创建在该子账号下（子账号不能被删除或者禁用），暂无法通过接口获取
     */
    @ApiModelProperty(name = "subAccount", value = "子账号邮箱，填写时频道会创建在该子账号下（子账号不能被删除或者禁用），暂无法通过接口获取", required = false)
    private String subAccount;
    
    /**
     * 参会人数 1-47：代表参会人数
     */
    @ApiModelProperty(name = "linkMicLimit", value = "参会人数 1-47：代表参会人数", required = false)
    private Integer linkMicLimit;
    
}