package net.polyv.seminar.v1.entity.channel;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 创建研讨会频道(旧版后台)响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("创建研讨会频道(旧版后台)响应实体")
public class SeminarCreateChannelResponse {
    
    /**
     * 直播频道号
     */
    @ApiModelProperty(name = "channelId", value = "直播频道号", required = false)
    private String channelId;
    
    /**
     * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
     */
    @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
    private String userId;
    
    /**
     * 直播频道名称
     */
    @ApiModelProperty(name = "name", value = "直播频道名称", required = false)
    private String name;
    
    /**
     * 主持人
     */
    @ApiModelProperty(name = "publisher", value = "主持人", required = false)
    private String publisher;
    
    /**
     * 直播频道描述
     */
    @ApiModelProperty(name = "description", value = "直播频道描述", required = false)
    private String description;
    
    /**
     * 直播场景 seminar：研讨会
     */
    @ApiModelProperty(name = "scene", value = "直播场景 seminar：研讨会", required = false)
    private String scene;
    
    /**
     * 频道密码
     */
    @ApiModelProperty(name = "channelPasswd", value = "频道密码", required = false)
    private String channelPasswd;
    
    /**
     * 当前时间
     */
    @ApiModelProperty(name = "currentTimeMillis", value = "当前时间", required = false)
    private Date currentTimeMillis;
    
}