package net.polyv.seminar.v1.service.playback.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import net.polyv.seminar.v1.config.SeminarGlobalConfig;
import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.playback.SeminarDeleteRecordRequest;
import net.polyv.seminar.v1.entity.playback.SeminarGetRecordInfoRequest;
import net.polyv.seminar.v1.entity.playback.SeminarGetRecordInfoResponse;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.playback.SeminarPlaybackService;

/**
 * 回放信息
 * @author: jiangyifan
 */
@Slf4j
public class SeminarPlaybackServiceImpl extends SeminarBaseService implements SeminarPlaybackService {
    
    /**
     * 查询录制视频
     * API地址：https://help.polyv.net/#/seminar/api/playback/get_record_info
     * @param seminarGetRecordInfoRequest 查询录制视频请求实体
     * @return 查询录制视频响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<SeminarGetRecordInfoResponse> getRecordInfo(SeminarGetRecordInfoRequest seminarGetRecordInfoRequest)
            throws IOException, NoSuchAlgorithmException {
        seminarGetRecordInfoRequest.setUserId(SeminarGlobalConfig.getUserId());
        String url = SeminarURL.getRealUrl(SeminarURL.SEMINAR_GET_RECORD_FILES_URL,
                seminarGetRecordInfoRequest.getChannelId());
        return this.getReturnList(url, seminarGetRecordInfoRequest, SeminarGetRecordInfoResponse.class);
    }
    
    /**
     * 删除录制视频
     * API地址：https://help.polyv.net/#/seminar/api/playback/delete_record
     * @param seminarDeleteRecordRequest 删除录制视频请求实体
     * @return 删除录制视频响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteRecord(SeminarDeleteRecordRequest seminarDeleteRecordRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.getRealUrl(SeminarURL.SEMINAR_DELETE_RECORD_FILES_URL,
                seminarDeleteRecordRequest.getChannelId());
        this.postFormBodyReturnOne(url, seminarDeleteRecordRequest, String.class);
        return Boolean.TRUE;
    }
}
