package net.polyv.seminar.v1.service.playback;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.seminar.v1.entity.playback.SeminarDeleteRecordRequest;
import net.polyv.seminar.v1.entity.playback.SeminarGetRecordInfoRequest;
import net.polyv.seminar.v1.entity.playback.SeminarGetRecordInfoResponse;

/**
 * 回放信息
 * @author: jiangyifan
 */
public interface SeminarPlaybackService {
    
    /**
     * 查询录制视频
     * API地址：https://help.polyv.net/#/seminar/api/playback/get_record_info
     * @param seminarGetRecordInfoRequest 查询录制视频请求实体
     * @return 查询录制视频响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<SeminarGetRecordInfoResponse> getRecordInfo(SeminarGetRecordInfoRequest seminarGetRecordInfoRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除录制视频
     * API地址：https://help.polyv.net/#/seminar/api/playback/delete_record
     * @param seminarDeleteRecordRequest 删除录制视频请求实体
     * @return 删除录制视频响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteRecord(SeminarDeleteRecordRequest seminarDeleteRecordRequest)
            throws IOException, NoSuchAlgorithmException;
}
