package net.polyv.seminar.v1.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 研讨会常量类
 * @author: jiangyifan
 */
public class SeminarConstant {
    
    public static final String UTF8 = "UTF-8";
    
    /**
     * 通用条件判断
     */
    @Getter
    @AllArgsConstructor
    public enum Flag {
        //Y=YES , N=NO
        YES("Y"), NO("N");
        
        private String flag;
    }
    
    /**
     * 观看条件
     */
    @Getter
    @AllArgsConstructor
    public enum AuthType {
        /**
         * 观看条件：付费观看
         */
        PAY("pay"),
        /**
         * 观看条件：验证码观看
         */
        CODE("code"),
        /**
         * 观看条件：白名单观看
         */
        PHONE("phone"),
        /**
         * 观看条件：登记观看
         */
        INFO("info"),
        /**
         * 观看条件：自定义授权观看
         */
        CUSTOM("custom"),
        /**
         * 观看条件：外部授权
         */
        EXTERNAL("external"),
        /**
         * 观看条件：直接授权
         */
        DIRECT("direct");
        
        private final String code;
    }
    
    /**
     * 参会条件
     */
    @Getter
    @AllArgsConstructor
    public enum SeminarAuthType {
        /**
         * 观看条件：独立授权
         */
        DIRECT("direct"),
        /**
         * 观看条件：密码登录
         */
        PASSWORD("password"),
        /**
         * 观看条件：自定义授权
         */
        CUSTOM("custom");
        
        private final String code;
    }
    
    /**
     * 角色
     */
    @Getter
    @AllArgsConstructor
    public enum RoleCode {
        /**
         * 主持人
         */
        HOST("host"),
        /**
         * 参会人
         */
        ATTENDEE("attendee");
        
        private final String code;
    }
    
    /**
     * 频道录制模式
     */
    @Getter
    @AllArgsConstructor
    public enum RecordMode {
        
        /**
         * 自动
         */
        auto("auto"),
        /**
         * 手动
         */
        manual("manual");
        
        private final String model;
    }
}
