/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.seminar.v1.service.playback.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import net.polyv.seminar.v1.config.SeminarGlobalConfig;
import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.playback.SeminarDeleteRecordRequest;
import net.polyv.seminar.v1.entity.playback.SeminarGetRecordInfoRequest;
import net.polyv.seminar.v1.entity.playback.SeminarGetRecordInfoResponse;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.playback.SeminarPlaybackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeminarPlaybackServiceImpl
extends SeminarBaseService
implements SeminarPlaybackService {
    private static final Logger log = LoggerFactory.getLogger(SeminarPlaybackServiceImpl.class);

    @Override
    public List<SeminarGetRecordInfoResponse> getRecordInfo(SeminarGetRecordInfoRequest seminarGetRecordInfoRequest) throws IOException, NoSuchAlgorithmException {
        seminarGetRecordInfoRequest.setUserId(SeminarGlobalConfig.getUserId());
        String url = SeminarURL.getRealUrl("api.polyv.net/live/v2/channels/%s/recordFiles", seminarGetRecordInfoRequest.getChannelId());
        return this.getReturnList(url, seminarGetRecordInfoRequest, SeminarGetRecordInfoResponse.class);
    }

    @Override
    public Boolean deleteRecord(SeminarDeleteRecordRequest seminarDeleteRecordRequest) throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.getRealUrl("api.polyv.net/live/v2/channel/recordFile/%s/delete-record", seminarDeleteRecordRequest.getChannelId());
        this.postFormBodyReturnOne(url, seminarDeleteRecordRequest, String.class);
        return Boolean.TRUE;
    }
}

