package net.polyv.seminar.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import lombok.extern.slf4j.Slf4j;
import net.polyv.seminar.v1.config.SeminarGlobalConfig;
import net.polyv.seminar.v1.constant.SeminarURL;
import net.polyv.seminar.v1.entity.channel.SeminarBatchDeleteChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelResponse;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelV2Request;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelV2Response;
import net.polyv.seminar.v1.entity.channel.SeminarDeleteChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetCdnViewLogRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetCdnViewLogResponse;
import net.polyv.seminar.v1.entity.channel.SeminarGetRecordSettingRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetRecordSettingResponse;
import net.polyv.seminar.v1.entity.channel.SeminarGetViewLogRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetViewLogResponse;
import net.polyv.seminar.v1.entity.channel.SeminarSetRecordSettingRequest;
import net.polyv.seminar.v1.service.SeminarBaseService;
import net.polyv.seminar.v1.service.channel.SeminarChannelService;

/**
 * 频道信息管理
 * @author: jiangyifan
 */
@Slf4j
public class SeminarChannelServiceImpl extends SeminarBaseService implements SeminarChannelService {
    
    /**
     * 创建研讨会频道(旧版后台)
     * API地址：https://help.polyv.net/#/seminar/api/info/basic_create
     * @param seminarCreateChannelRequest 创建研讨会频道(旧版后台)请求实体
     * @return 创建研讨会频道(旧版后台)响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public SeminarCreateChannelResponse createChannel(SeminarCreateChannelRequest seminarCreateChannelRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_CREATE_CHANNEL_URL;
        return this.postJsonBodyReturnOne(url, seminarCreateChannelRequest, SeminarCreateChannelResponse.class);
    }
    
    /**
     * 创建研讨会频道(新版后台)
     * API地址：https://help.polyv.net/#/seminar/api/info/create
     * @param seminarCreateChannelV2Request 创建研讨会频道(新版后台)请求实体
     * @return 创建研讨会频道(新版后台)响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public SeminarCreateChannelV2Response createChannelV2(SeminarCreateChannelV2Request seminarCreateChannelV2Request)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_CREATE_CHANNEL_V2_URL;
        return this.postJsonBodyReturnOne(url, seminarCreateChannelV2Request, SeminarCreateChannelV2Response.class);
    }
    
    /**
     * 获取研讨会频道录制设置
     * API地址：https://help.polyv.net/#/seminar/api/info/get_record_setting
     * @param seminarGetRecordSettingRequest 获取研讨会频道录制设置请求实体
     * @return 获取研讨会频道录制设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public SeminarGetRecordSettingResponse getRecordSetting(
            SeminarGetRecordSettingRequest seminarGetRecordSettingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_GET_RECORD_URL;
        return this.getReturnOne(url, seminarGetRecordSettingRequest, SeminarGetRecordSettingResponse.class);
    }
    
    /**
     * 修改研讨会频道录制设置
     * API地址：https://help.polyv.net/#/seminar/api/info/set_record_setting
     * @param seminarSetRecordSettingRequest 修改研讨会频道录制设置请求实体
     * @return 修改研讨会频道录制设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean setRecordSetting(SeminarSetRecordSettingRequest seminarSetRecordSettingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_SET_RECORD_URL;
        this.postFormBodyReturnOne(url, seminarSetRecordSettingRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 获取研讨会直播间参会者统计数据
     * API地址：https://help.polyv.net/#/seminar/api/info/get_seminar_view_log
     * @param seminarGetViewLogRequest 获取研讨会直播间参会者统计数据请求实体
     * @return 获取研讨会直播间参会者统计数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public SeminarGetViewLogResponse getViewLog(SeminarGetViewLogRequest seminarGetViewLogRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_GET_VIEW_LOG_URL;
        return this.getReturnOne(url, seminarGetViewLogRequest, SeminarGetViewLogResponse.class);
    }
    
    /**
     * 获取直播间观众统计数据
     * API地址：https://help.polyv.net/#/seminar/api/info/get_cdn_view_log
     * @param seminarGetCdnViewLogRequest 获取直播间观众统计数据请求实体
     * @return 获取直播间观众统计数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public SeminarGetCdnViewLogResponse getCdnViewLog(SeminarGetCdnViewLogRequest seminarGetCdnViewLogRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_GET_CDN_VIEW_LOG_URL;
        return this.getReturnOne(url, seminarGetCdnViewLogRequest, SeminarGetCdnViewLogResponse.class);
    }
    
    /**
     * 删除单个频道
     * API地址：https://help.polyv.net/#/seminar/api/info/delete_channel
     * @param seminarDeleteChannelRequest 删除单个频道请求实体
     * @return 删除单个频道响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteChannel(SeminarDeleteChannelRequest seminarDeleteChannelRequest)
            throws IOException, NoSuchAlgorithmException {
        seminarDeleteChannelRequest.setUserId(SeminarGlobalConfig.getUserId());
        String url = SeminarURL.getRealUrl(SeminarURL.SEMINAR_DELETE_CHANNEL_URL,
                seminarDeleteChannelRequest.getChannelId());
        return this.postFormBodyReturnOne(url, seminarDeleteChannelRequest, Boolean.class);
    }
    
    /**
     * 批量删除频道
     * API地址：https://help.polyv.net/#/seminar/api/info/batch_delete_channels
     * @param seminarBatchDeleteChannelRequest 批量删除频道请求实体
     * @return 批量删除频道响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean batchDeleteChannel(SeminarBatchDeleteChannelRequest seminarBatchDeleteChannelRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = SeminarURL.SEMINAR_DELETE_CHANNEL_BATCH_URL;
        return this.postJsonBodyReturnOne(url, seminarBatchDeleteChannelRequest, Boolean.class);
    }
    
}
