package net.polyv.seminar.v1.entity.channel;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.seminar.v1.entity.SeminarPageCommonResponse;

/**
 * 获取研讨会直播间参会者统计数据响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("获取研讨会直播间参会者统计数据响应实体")
public class SeminarGetViewLogResponse extends SeminarPageCommonResponse {
    
    @ApiModelProperty(name = "contents", value = "参会者统计数据", required = false)
    private List<ViewLog> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("参会者统计数据")
    public static class ViewLog {
        
        /**
         * UID
         */
        @ApiModelProperty(name = "viewerId", value = "UID", required = false)
        private String viewerId;
        
        /**
         * 昵称
         */
        @ApiModelProperty(name = "nickName", value = "昵称", required = false)
        private String nickName;
        
        /**
         * 国家
         */
        @ApiModelProperty(name = "country", value = "国家", required = false)
        private String country;
        
        /**
         * 地区
         */
        @ApiModelProperty(name = "province", value = "地区", required = false)
        private String province;
        
        /**
         * 城市
         */
        @ApiModelProperty(name = "city", value = "城市", required = false)
        private String city;
        
        /**
         * 参会人IP
         */
        @ApiModelProperty(name = "ipAddress", value = "参会人IP", required = false)
        private String ipAddress;
        
        /**
         * 进入时间
         */
        @ApiModelProperty(name = "startTime", value = "进入时间", required = false)
        private Date startTime;
        
        /**
         * 退出时间
         */
        @ApiModelProperty(name = "endTime", value = "退出时间", required = false)
        private Date endTime;
        
        /**
         * 进入时长（单位：秒）
         */
        @ApiModelProperty(name = "stayDuration", value = "进入时长（单位：秒）", required = false)
        private Integer stayDuration;
        
        /**
         * 连麦次数
         */
        @ApiModelProperty(name = "micCount", value = "连麦次数", required = false)
        private Integer micCount;
        
        /**
         * 连麦时长（单位：秒）
         */
        @ApiModelProperty(name = "micDuration", value = "连麦时长（单位：秒）", required = false)
        private Integer micDuration;
        
        /**
         * 演示次数
         */
        @ApiModelProperty(name = "showCount", value = "演示次数", required = false)
        private Integer showCount;
        
        /**
         * 演示时长（单位：秒）
         */
        @ApiModelProperty(name = "showDuration", value = "演示时长（单位：秒）", required = false)
        private Integer showDuration;
        
        /**
         * 是否移动端，取值Y 移动端； N PC端
         */
        @ApiModelProperty(name = "isMobile", value = "是否移动端，取值Y 移动端； N PC端", required = false)
        private String isMobile;
    }
}