package net.polyv.seminar.v1.entity.channel;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 创建研讨会频道(旧版后台)请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("创建研讨会频道(旧版后台)请求实体")
public class SeminarCreateChannelRequest extends SeminarCommonRequest {
    
    /**
     * 基础设置
     */
    @ApiModelProperty(name = "basicSetting", value = "基础设置", required = true)
    @NotNull(message = "属性basicSetting不能为空")
    private BasicSetting basicSetting;
    
    /**
     * 观看条件设置
     */
    @ApiModelProperty(name = "authSettings", value = "观看条件设置", required = false)
    private List<AuthSetting> authSettings;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("基础设置")
    public static class BasicSetting {
        
        /**
         * 频道名称
         */
        @ApiModelProperty(name = "name", value = "频道名称", required = true)
        @NotNull(message = "属性name不能为空")
        private String name;
        
        /**
         * 频道密码，（可以通过频道号+频道密码登录该频道）长度不能超过16位，必须同时包含字母和数字
         */
        @ApiModelProperty(name = "channelPasswd", value = "频道密码，（可以通过频道号+频道密码登录该频道）长度不能超过16位，必须同时包含字母和数字", required =
                true)
        @NotNull(message = "属性channelPasswd不能为空")
        private String channelPasswd;
        
        /**
         * 直播场景 seminar：研讨会
         */
        @ApiModelProperty(hidden = true, required = true)
        @NotNull(message = "属性scene不能为空")
        private String scene = "seminar";
        
        /**
         * 新建频道的所属分类，如果不提交，则为默认分类（分类ID可通过“查询直播分类”接口得到）
         */
        @ApiModelProperty(name = "categoryId", value = "新建频道的所属分类，如果不提交，则为默认分类（分类ID可通过“查询直播分类”接口得到）", required = false)
        private Integer categoryId;
        
        /**
         * 封面图片地址
         */
        @ApiModelProperty(name = "coverImg", value = "封面图片地址", required = false)
        private String coverImg;
        
        /**
         * 点赞数
         */
        @ApiModelProperty(name = "likes", value = "点赞数", required = false)
        private Long likes;
        
        /**
         * 累积观看数
         */
        @ApiModelProperty(name = "pageView", value = "累积观看数", required = false)
        private Long pageView;
        
        /**
         * 子账号邮箱，填写时频道会创建在该子账号下（子账号不能被删除或者禁用），暂无法通过接口获取
         */
        @ApiModelProperty(name = "subAccount", value = "子账号邮箱，填写时频道会创建在该子账号下（子账号不能被删除或者禁用），暂无法通过接口获取", required = false)
        private String subAccount;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("观看条件设置")
    public static class AuthSetting {
        
        /**
         * 主要观看条件为1，次要观看条件为2
         */
        @ApiModelProperty(name = "rank", value = "主要观看条件为1，次要观看条件为2", required = true)
        @NotNull(message = "属性rank不能为空")
        private Integer rank;
        
        /**
         * 是否开启条件观看 N：关闭 Y：开启
         */
        @ApiModelProperty(name = "enabled", value = "是否开启条件观看 N：关闭 Y：开启", required = true)
        @NotNull(message = "属性enabled不能为空")
        private String enabled;
        
        /**
         * 观看条件 pay：付费观看 code：验证码观看 phone：白名单观看 info：登记观看 custom：自定义授权观看 external：外部授权观看 direct：独立授权观看
         */
        @ApiModelProperty(name = "authType", value = "pay：付费观看 code：验证码观看 phone：白名单观看 info：登记观看 custom：自定义授权观看 " +
                "external：外部授权观看 direct：独立授权观看", required = false)
        private String authType;
        
        /**
         * 当authType为pay时，设置参数，必填。欢迎语标题
         */
        @ApiModelProperty(name = "payAuthTips", value = "当authType为pay时，设置参数，必填。欢迎语标题", required = false)
        private String payAuthTips;
        
        /**
         * 当authType为pay时，设置参数，必填。价格，单位为元
         */
        @ApiModelProperty(name = "price", value = "当authType为pay时，设置参数，必填。价格，单位为元", required = false)
        private Float price;
        
        /**
         * 当authType为pay时，设置参数，非必填。付费有效截止日期
         */
        @ApiModelProperty(name = "watchEndTime", value = "当authType为pay时，设置参数，非必填。付费有效截止日期",
                required = false)
        private Date watchEndTime;
        
        /**
         * 当authType为pay时，设置参数，非必填。付费有效时长，单位天。当watchEndTime和validTimePeriod都为空时，表示付费永久有效
         */
        @ApiModelProperty(name = "validTimePeriod", value = "当authType为pay时，设置参数，非必填。付费有效时长，单位天。当watchEndTime" +
                "和validTimePeriod都为空时，表示付费永久有效", required = false)
        private Integer validTimePeriod;
        
        /**
         * 当authType为code时，设置参数，必填。验证码
         */
        @ApiModelProperty(name = "authCode", value = "当authType为code时，设置参数，必填。验证码", required = false)
        private String authCode;
        
        /**
         * 当authType为code时，设置参数，非必填。提示文案
         */
        @ApiModelProperty(name = "qcodeTips", value = "当authType为code时，设置参数，非必填。提示文案", required = false)
        private String qcodeTips;
        
        /**
         * 当authType为code时，设置参数，非必填。公众号二维码地址
         */
        @ApiModelProperty(name = "qcodeImg", value = "当authType为code时，设置参数，非必填。公众号二维码地址", required = false)
        private String qcodeImg;
        
        /**
         * 当authType为phone时，设置参数，非必填。提示文案
         */
        @ApiModelProperty(name = "authTips", value = "当authType为phone时，设置参数，非必填。提示文案", required = false)
        private String authTips;
        
        /**
         * 当authType为info时，设置参数，必填。登记观看信息，上限为5个
         */
        @ApiModelProperty(name = "infoFields", value = "当authType为info时，设置参数，必填。登记观看信息，上限为5个",
                required = false)
        private List<InfoField> infoFields;
        
        /**
         * 当authType为external时，设置参数，必填。SecretKey
         */
        @ApiModelProperty(name = "externalKey", value = "当authType为external时，设置参数，必填。SecretKey", required = false)
        private String externalKey;
        
        /**
         * 当authType为external时，设置参数，必填。自定义url
         */
        @ApiModelProperty(name = "externalUri", value = "当authType为external时，设置参数，必填。自定义url", required = false)
        private String externalUri;
        
        /**
         * 当authType为external时，设置参数，非必填。跳转地址
         */
        @ApiModelProperty(name = "externalRedirectUri", value = "当authType为external时，设置参数，非必填。跳转地址", required = false)
        private String externalRedirectUri;
        
        /**
         * 当authType为custom时，设置参数，必填。SecretKey
         */
        @ApiModelProperty(name = "customKey", value = "当authType为custom时，设置参数，必填。SecretKey", required = false)
        private String customKey;
        
        /**
         * 当authType为custom时，设置参数，必填。自定义url
         */
        @ApiModelProperty(name = "customUri", value = "当authType为custom时，设置参数，必填。自定义url", required = false)
        private String customUri;
        
        /**
         * 当authType为direct时，设置参数，必填。独立授权SecretKey
         */
        @ApiModelProperty(name = "directKey", value = "当authType为direct时，设置参数，必填。独立授权SecretKey", required = false)
        private String directKey;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("登记观看参数")
    public static class InfoField {
        /**
         * 登记信息名，最多为8字符
         */
        @ApiModelProperty(name = "name", value = "登记信息名，最多为8字符", required = false)
        private String name;
        
        /**
         * 登记类型，姓名-name，文本-text，手机号码-mobile，数字-number，下拉选项-option，登记观看时该字段必填
         */
        @ApiModelProperty(name = "type", value = "登记类型，姓名-name，文本-text，手机号码-mobile，数字-number，下拉选项-option，登记观看时该字段必填",
                required = true)
        @NotNull(message = "属性type不能为空")
        private String type;
        
        /**
         * 下拉选项时，下拉的选项值，以英文逗号分割。选项个数上限为8个；选项内容最多为8字符
         */
        @ApiModelProperty(name = "options", value = "下拉选项时，下拉的选项值，以英文逗号分割。选项个数上限为8个；选项内容最多为8字符", required = false)
        private String options;
        
        /**
         * 文本框输入提示，最多为8字符
         */
        @ApiModelProperty(name = "placeholder", value = "文本框输入提示，最多为8字符", required = false)
        private String placeholder;
        
        /**
         * 短信验证开关，Y 开启，N 关闭
         */
        @ApiModelProperty(name = "sms", value = "短信验证开关，Y 开启，N 关闭", required = false)
        private String sms;
    }
}