package net.polyv.seminar.v1.entity.playback;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.seminar.v1.entity.SeminarCommonRequest;

/**
 * 删除录制视频请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("删除录制视频请求实体")
public class SeminarDeleteRecordRequest extends SeminarCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 录制视频的场次ID
     */
    @ApiModelProperty(name = "sessionId", value = "录制视频的场次ID", required = false)
    private String sessionId;
    
    /**
     * 录制视频的开始录制时间，格式为：yyyyMMddHHmmss，如：20210317181043【可通过查询频道录制视频信息获取】
     */
    @ApiModelProperty(name = "startTime", value = "录制视频的开始录制时间，格式为：yyyyMMddHHmmss，如：20210317181043【可通过查询频道录制视频信息获取】",
            required = false)
    @JSONField(format = "yyyyMMddhhmmss")
    private Date startTime;
    
}