package net.polyv.seminar.v1.service.channel;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.seminar.v1.entity.channel.SeminarBatchDeleteChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelResponse;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelV2Request;
import net.polyv.seminar.v1.entity.channel.SeminarCreateChannelV2Response;
import net.polyv.seminar.v1.entity.channel.SeminarDeleteChannelRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetCdnViewLogRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetCdnViewLogResponse;
import net.polyv.seminar.v1.entity.channel.SeminarGetRecordSettingRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetRecordSettingResponse;
import net.polyv.seminar.v1.entity.channel.SeminarGetViewLogRequest;
import net.polyv.seminar.v1.entity.channel.SeminarGetViewLogResponse;

/**
 * 频道信息管理
 * @author: jiangyifan
 */
public interface SeminarChannelService {
    
    /**
     * 创建研讨会频道(旧版后台)
     * API地址：https://help.polyv.net/#/seminar/api/info/basic_create
     * @param seminarCreateChannelRequest 创建研讨会频道(旧版后台)请求实体
     * @return 创建研讨会频道(旧版后台)响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    SeminarCreateChannelResponse createChannel(SeminarCreateChannelRequest seminarCreateChannelRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 创建研讨会频道(新版后台)
     * API地址：https://help.polyv.net/#/seminar/api/info/create
     * @param seminarCreateChannelV2Request 创建研讨会频道(新版后台)请求实体
     * @return 创建研讨会频道(新版后台)响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    SeminarCreateChannelV2Response createChannelV2(SeminarCreateChannelV2Request seminarCreateChannelV2Request)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 获取研讨会频道录制设置
     * API地址：https://help.polyv.net/#/seminar/api/info/get_record_setting
     * @param seminarGetRecordSettingRequest 获取研讨会频道录制设置请求实体
     * @return 获取研讨会频道录制设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    SeminarGetRecordSettingResponse getRecordSetting(SeminarGetRecordSettingRequest seminarGetRecordSettingRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 获取研讨会直播间参会者统计数据
     * API地址：https://help.polyv.net/#/seminar/api/info/get_seminar_view_log
     * @param seminarGetViewLogRequest 获取研讨会直播间参会者统计数据请求实体
     * @return 获取研讨会直播间参会者统计数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    SeminarGetViewLogResponse getViewLog(SeminarGetViewLogRequest seminarGetViewLogRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 获取直播间观众统计数据
     * API地址：https://help.polyv.net/#/seminar/api/info/get_cdn_view_log
     * @param seminarGetCdnViewLogRequest 获取直播间观众统计数据请求实体
     * @return 获取直播间观众统计数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    SeminarGetCdnViewLogResponse getCdnViewLog(SeminarGetCdnViewLogRequest seminarGetCdnViewLogRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除单个频道
     * API地址：https://help.polyv.net/#/seminar/api/info/delete_channel
     * @param seminarDeleteChannelRequest 删除单个频道请求实体
     * @return 删除单个频道响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteChannel(SeminarDeleteChannelRequest seminarDeleteChannelRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 批量删除频道
     * API地址：https://help.polyv.net/#/seminar/api/info/batch_delete_channels
     * @param seminarBatchDeleteChannelRequest 批量删除频道请求实体
     * @return 批量删除频道响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean batchDeleteChannel(SeminarBatchDeleteChannelRequest seminarBatchDeleteChannelRequest)
            throws IOException, NoSuchAlgorithmException;
}
